/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.profitbricks.compute.function;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.domain.Location;
import org.jclouds.location.predicates.LocationPredicates;
import org.jclouds.profitbricks.domain.Image;
import org.jclouds.profitbricks.domain.OsType;
import org.jclouds.profitbricks.domain.Provisionable;
import org.jclouds.profitbricks.domain.ProvisioningState;
import org.jclouds.profitbricks.domain.Snapshot;

public class ProvisionableToImage
implements Function<Provisionable, org.jclouds.compute.domain.Image> {
    public static final String KEY_PROVISIONABLE_TYPE = "provisionableType";
    private final ImageToImage fnImageToImage;
    private final SnapshotToImage fnSnapshotToImage;

    @Inject
    ProvisionableToImage(@Memoized Supplier<Set<? extends Location>> locations) {
        this.fnImageToImage = new ImageToImage(locations);
        this.fnSnapshotToImage = new SnapshotToImage(locations);
    }

    public org.jclouds.compute.domain.Image apply(Provisionable input) {
        Preconditions.checkNotNull((Object)input, (Object)"Cannot convert null input");
        if (input instanceof Image) {
            return this.fnImageToImage.apply((Image)input);
        }
        if (input instanceof Snapshot) {
            return this.fnSnapshotToImage.apply((Snapshot)input);
        }
        throw new UnsupportedOperationException("No implementation found for provisionable of concrete type '" + input.getClass().getCanonicalName() + "'");
    }

    private static OsFamily mapOsFamily(OsType osType) {
        if (osType == null) {
            return OsFamily.UNRECOGNIZED;
        }
        switch (osType) {
            case WINDOWS: {
                return OsFamily.WINDOWS;
            }
            case LINUX: {
                return OsFamily.LINUX;
            }
        }
        return OsFamily.UNRECOGNIZED;
    }

    private static class ImageToImage
    implements ImageFunction<Image> {
        private static final Pattern HAS_NUMBERS = Pattern.compile(".*\\d+.*");
        private final Supplier<Set<? extends Location>> locations;

        ImageToImage(Supplier<Set<? extends Location>> locations) {
            this.locations = locations;
        }

        public org.jclouds.compute.domain.Image apply(Image from) {
            String desc = from.name();
            OsFamily osFamily = this.parseOsFamily(desc, from.osType());
            Location location = (Location)Iterables.find((Iterable)((Iterable)this.locations.get()), (Predicate)LocationPredicates.idEquals((String)from.location().getId()));
            OperatingSystem os = OperatingSystem.builder().description(osFamily.value()).family(osFamily).version(this.parseVersion(desc)).is64Bit(this.is64Bit(desc, from.type())).build();
            return this.addTypeMetadata(new ImageBuilder().ids(from.id()).name(desc).location(location).status(Image.Status.AVAILABLE).operatingSystem(os)).build();
        }

        private OsFamily parseOsFamily(String from, OsType fallbackValue) {
            if (from != null) {
                try {
                    String desc = from.toUpperCase().split("-")[0];
                    OsFamily osFamily = OsFamily.fromValue((String)desc);
                    Preconditions.checkArgument((osFamily != OsFamily.UNRECOGNIZED ? 1 : 0) != 0);
                    return osFamily;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return ProvisionableToImage.mapOsFamily(fallbackValue);
        }

        private String parseVersion(String from) {
            String[] split;
            if (from != null && (split = from.toLowerCase().split("-")).length >= 2) {
                int i = 1;
                String version = split[i];
                while (!HAS_NUMBERS.matcher(version).matches()) {
                    version = split[++i];
                }
                return version;
            }
            return "";
        }

        private boolean is64Bit(String from, Image.Type type) {
            switch (type) {
                case CDROM: {
                    if (Strings.isNullOrEmpty((String)from)) break;
                    return from.matches("x86_64|amd64");
                }
            }
            return true;
        }

        @Override
        public ImageBuilder addTypeMetadata(ImageBuilder builder) {
            return builder.userMetadata((Map)ImmutableMap.of((Object)ProvisionableToImage.KEY_PROVISIONABLE_TYPE, (Object)Provisionable.Type.IMAGE.toString()));
        }
    }

    private static class SnapshotToImage
    implements ImageFunction<Snapshot> {
        private final Supplier<Set<? extends Location>> locations;

        SnapshotToImage(Supplier<Set<? extends Location>> locations) {
            this.locations = locations;
        }

        public org.jclouds.compute.domain.Image apply(Snapshot from) {
            String textToParse = from.name() + from.description();
            OsFamily osFamily = this.parseOsFamily(textToParse, from.osType());
            Location location = (Location)Iterables.find((Iterable)((Iterable)this.locations.get()), (Predicate)LocationPredicates.idEquals((String)from.location().getId()));
            OperatingSystem os = OperatingSystem.builder().description(osFamily.value()).family(osFamily).is64Bit(true).version("00.00").build();
            return this.addTypeMetadata(new ImageBuilder().ids(from.id()).name(from.name()).description(from.description()).location(location).status(SnapshotToImage.mapStatus(from.state())).operatingSystem(os)).build();
        }

        private OsFamily parseOsFamily(String text, OsType fallbackValue) {
            if (text != null) {
                try {
                    OsFamily[] families;
                    for (OsFamily family : families = OsFamily.values()) {
                        if (!text.contains(family.value())) continue;
                        return family;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return ProvisionableToImage.mapOsFamily(fallbackValue);
        }

        static Image.Status mapStatus(ProvisioningState state) {
            if (state == null) {
                return Image.Status.UNRECOGNIZED;
            }
            switch (state) {
                case AVAILABLE: {
                    return Image.Status.AVAILABLE;
                }
                case DELETED: {
                    return Image.Status.DELETED;
                }
                case ERROR: {
                    return Image.Status.ERROR;
                }
                case INACTIVE: 
                case INPROCESS: {
                    return Image.Status.PENDING;
                }
            }
            return Image.Status.UNRECOGNIZED;
        }

        @Override
        public ImageBuilder addTypeMetadata(ImageBuilder builder) {
            return builder.userMetadata((Map)ImmutableMap.of((Object)ProvisionableToImage.KEY_PROVISIONABLE_TYPE, (Object)Provisionable.Type.SNAPSHOT.toString()));
        }
    }

    private static interface ImageFunction<T extends Provisionable>
    extends Function<T, org.jclouds.compute.domain.Image> {
        public ImageBuilder addTypeMetadata(ImageBuilder var1);
    }
}

