/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.functions;

import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.jclouds.reflect.InvocationSuccess;
import org.jclouds.rest.annotations.ApiVersion;
import org.jclouds.rest.annotations.SinceApiVersion;
import org.jclouds.rest.functions.ImplicitOptionalConverter;
import org.jclouds.util.Optionals2;

@Singleton
@Beta
public class PresentWhenApiVersionLexicographicallyAtOrAfterSinceApiVersion
implements ImplicitOptionalConverter {
    private final LoadingCache<InvocationSuccess, Optional<Object>> lookupCache;

    @Inject
    protected PresentWhenApiVersionLexicographicallyAtOrAfterSinceApiVersion(@ApiVersion String apiVersion) {
        this.lookupCache = CacheBuilder.newBuilder().build((CacheLoader)new Loader(apiVersion));
    }

    public Optional<Object> apply(InvocationSuccess input) {
        return (Optional)this.lookupCache.getUnchecked((Object)input);
    }

    @VisibleForTesting
    static final class Loader
    extends CacheLoader<InvocationSuccess, Optional<Object>> {
        private final String apiVersion;

        @Inject
        Loader(@ApiVersion String apiVersion) {
            this.apiVersion = (String)Preconditions.checkNotNull((Object)apiVersion, (Object)"apiVersion");
        }

        public Optional<Object> load(InvocationSuccess input) {
            Class<?> target = Optionals2.unwrapIfOptional(input.getInvocation().getInvokable().getReturnType());
            Optional sinceApiVersion = Optional.fromNullable((Object)target.getAnnotation(SinceApiVersion.class));
            if (sinceApiVersion.isPresent()) {
                String since = ((SinceApiVersion)sinceApiVersion.get()).value();
                if (since.compareTo(this.apiVersion) <= 0) {
                    return input.getResult();
                }
                return Optional.absent();
            }
            return input.getResult();
        }
    }
}

