/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.rest.binders;

import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import java.util.Map;
import org.jclouds.http.HttpRequest;
import org.jclouds.json.Json;
import org.jclouds.rest.MapBinder;

public class BindToJsonPayload
implements MapBinder {
    protected final Json jsonBinder;

    @Inject
    public BindToJsonPayload(Json jsonBinder) {
        this.jsonBinder = (Json)Preconditions.checkNotNull((Object)jsonBinder, (Object)"jsonBinder");
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        return this.bindToRequest(request, (Object)postParams);
    }

    @Override
    public <R extends HttpRequest> R bindToRequest(R request, Object payload) {
        String json = this.jsonBinder.toJson(Preconditions.checkNotNull((Object)payload, (Object)"payload"));
        request.setPayload(json);
        request.getPayload().getContentMetadata().setContentType("application/json");
        return request;
    }
}

