/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.location.predicates.fromconfig;

import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.jclouds.location.predicates.RegionIdFilter;
import org.jclouds.location.suppliers.fromconfig.RegionIdsFromConfiguration;

@Singleton
public class AnyOrConfiguredRegionId
implements RegionIdFilter {
    private RegionIdsFromConfiguration idsInConfigSupplier;

    @Inject
    protected AnyOrConfiguredRegionId(RegionIdsFromConfiguration idsInConfigSupplier) {
        this.idsInConfigSupplier = (RegionIdsFromConfiguration)Preconditions.checkNotNull((Object)idsInConfigSupplier, (Object)"idsInConfigSupplier");
    }

    public boolean apply(String input) {
        Object idsInConfig = this.idsInConfigSupplier.get();
        if (idsInConfig.isEmpty()) {
            return true;
        }
        return idsInConfig.contains(input);
    }

    public String toString() {
        return "anyOrConfiguredRegionId(" + String.valueOf(this.idsInConfigSupplier) + ")";
    }
}

