/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.config;

import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.MapMaker;
import com.google.inject.AbstractModule;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import jakarta.annotation.Resource;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.jclouds.logging.Logger;

public class SSLModule
extends AbstractModule {
    protected void configure() {
        this.bind(HostnameVerifier.class).annotatedWith((Annotation)Names.named((String)"untrusted")).to(LogToMapHostnameVerifier.class);
        this.bind((TypeLiteral)new TypeLiteral<Supplier<SSLContext>>(){}).annotatedWith((Annotation)Names.named((String)"untrusted")).to((TypeLiteral)new TypeLiteral<UntrustedSSLContextSupplier>(){});
        this.bind(X509TrustManager.class).annotatedWith((Annotation)Names.named((String)"untrusted")).to(TrustAllCerts.class);
    }

    @Singleton
    public static class LogToMapHostnameVerifier
    implements HostnameVerifier {
        @Resource
        private Logger logger = Logger.NULL;
        private final Map<String, String> sslMap = new MapMaker().makeMap();

        @Override
        public boolean verify(String hostname, SSLSession session) {
            String oldPeerHost;
            String peerHost = session.getPeerHost();
            if (!(hostname.equals(peerHost) || (oldPeerHost = this.sslMap.get(hostname)) != null && oldPeerHost.equals(peerHost))) {
                this.logger.warn("hostname was %s while session was %s", hostname, peerHost);
                this.sslMap.put(hostname, peerHost);
            }
            return true;
        }
    }

    @Singleton
    public static class TrustAllCerts
    implements X509TrustManager {
        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }

    @Singleton
    public static class UntrustedSSLContextSupplier
    implements Supplier<SSLContext> {
        private final SSLContext sslContext;

        @Inject
        UntrustedSSLContextSupplier(TrustAllCerts trustAllCerts) {
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, new TrustManager[]{trustAllCerts}, new SecureRandom());
                this.sslContext = sslContext;
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }

        public SSLContext get() {
            return this.sslContext;
        }
    }
}

