/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.events.config;

import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.concurrent.Executor;
import org.jclouds.events.config.ConfiguresEventBus;
import org.jclouds.events.config.annotations.AsyncBus;
import org.jclouds.events.handlers.DeadEventLoggingHandler;

@ConfiguresEventBus
public class EventBusModule
extends AbstractModule {
    @Provides
    @Singleton
    final AsyncEventBus provideAsyncEventBus(@Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, DeadEventLoggingHandler deadEventsHandler) {
        AsyncEventBus asyncBus = new AsyncEventBus("jclouds-async-event-bus", (Executor)userExecutor);
        asyncBus.register((Object)deadEventsHandler);
        return asyncBus;
    }

    @Provides
    @Singleton
    final EventBus provideSyncEventBus(DeadEventLoggingHandler deadEventsHandler) {
        EventBus syncBus = new EventBus("jclouds-sync-event-bus");
        syncBus.register((Object)deadEventsHandler);
        return syncBus;
    }

    protected void configure() {
        this.bind(EventBus.class).annotatedWith(AsyncBus.class).to(AsyncEventBus.class).in(Scopes.SINGLETON);
    }
}

