/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.apis;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.reflect.TypeToken;
import org.jclouds.View;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.util.TypeTokenUtils;

public class ApiPredicates {
    public static Predicate<ApiMetadata> all() {
        return Predicates.alwaysTrue();
    }

    public static Predicate<ApiMetadata> id(final String id) {
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)id), (Object)"id must be defined");
        return new Predicate<ApiMetadata>(){

            public boolean apply(ApiMetadata apiMetadata) {
                return apiMetadata.getId().equals(id);
            }

            public String toString() {
                return "id(" + id + ")";
            }
        };
    }

    public static Predicate<ApiMetadata> contextAssignableFrom(final TypeToken<?> type) {
        Preconditions.checkNotNull(type, (Object)"context must be defined");
        return new Predicate<ApiMetadata>(){

            public boolean apply(ApiMetadata apiMetadata) {
                return TypeTokenUtils.isSupertypeOf(type, apiMetadata.getContext());
            }

            public String toString() {
                return "contextAssignableFrom(" + String.valueOf(type) + ")";
            }
        };
    }

    public static Predicate<ApiMetadata> viewableAs(final TypeToken<?> type) {
        Preconditions.checkNotNull(type, (Object)"context must be defined");
        return new Predicate<ApiMetadata>(){

            public boolean apply(ApiMetadata apiMetadata) {
                for (TypeToken<? extends View> to : apiMetadata.getViews()) {
                    if (!TypeTokenUtils.isSupertypeOf(type, to)) continue;
                    return true;
                }
                return false;
            }

            public String toString() {
                return "viewableAs(" + String.valueOf(type) + ")";
            }
        };
    }
}

