/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.http.okhttp.config;

import com.google.common.base.Supplier;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import jakarta.inject.Named;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import okhttp3.OkHttpClient;
import org.jclouds.http.HttpCommandExecutorService;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.config.ConfiguresHttpCommandExecutorService;
import org.jclouds.http.config.SSLModule;
import org.jclouds.http.okhttp.OkHttpClientSupplier;
import org.jclouds.http.okhttp.OkHttpCommandExecutorService;

@ConfiguresHttpCommandExecutorService
public class OkHttpCommandExecutorServiceModule
extends AbstractModule {
    protected void configure() {
        this.install((Module)new SSLModule());
        this.bind(HttpCommandExecutorService.class).to(OkHttpCommandExecutorService.class).in(Scopes.SINGLETON);
        this.bind(OkHttpClient.class).toProvider(OkHttpClientProvider.class).in(Scopes.SINGLETON);
    }

    private static final class OkHttpClientProvider
    implements Provider<OkHttpClient> {
        private final HostnameVerifier verifier;
        private final Supplier<SSLContext> untrustedSSLContextProvider;
        private final X509TrustManager trustAllCertsManager;
        private final HttpUtils utils;
        private final OkHttpClientSupplier clientSupplier;

        @Inject
        OkHttpClientProvider(HttpUtils utils, @Named(value="untrusted") HostnameVerifier verifier, @Named(value="untrusted") Supplier<SSLContext> untrustedSSLContextProvider, @Named(value="untrusted") X509TrustManager trustAllCertsManager, OkHttpClientSupplier clientSupplier) {
            this.utils = utils;
            this.verifier = verifier;
            this.untrustedSSLContextProvider = untrustedSSLContextProvider;
            this.trustAllCertsManager = trustAllCertsManager;
            this.clientSupplier = clientSupplier;
        }

        public OkHttpClient get() {
            OkHttpClient.Builder clientBuilder = ((OkHttpClient)this.clientSupplier.get()).newBuilder().connectTimeout((long)this.utils.getConnectionTimeout(), TimeUnit.MILLISECONDS).readTimeout((long)this.utils.getSocketOpenTimeout(), TimeUnit.MILLISECONDS).followRedirects(false);
            if (this.utils.relaxHostname()) {
                clientBuilder.hostnameVerifier(this.verifier);
            }
            if (this.utils.trustAllCerts()) {
                clientBuilder.sslSocketFactory(((SSLContext)this.untrustedSSLContextProvider.get()).getSocketFactory(), this.trustAllCertsManager);
            }
            return clientBuilder.build();
        }
    }
}

