/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.jclouds.azureblob.blobstore.functions.BlobPropertiesToBlobMetadata;
import org.jclouds.azureblob.domain.AzureBlob;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.io.Payload;

@Singleton
public class AzureBlobToBlob
implements Function<AzureBlob, Blob> {
    private final Blob.Factory blobFactory;
    private final BlobPropertiesToBlobMetadata blobPr2BlobMd;

    @Inject
    AzureBlobToBlob(Blob.Factory blobFactory, BlobPropertiesToBlobMetadata blobPr2BlobMd) {
        this.blobFactory = (Blob.Factory)Preconditions.checkNotNull((Object)blobFactory, (Object)"blobFactory");
        this.blobPr2BlobMd = (BlobPropertiesToBlobMetadata)Preconditions.checkNotNull((Object)blobPr2BlobMd, (Object)"blobPr2BlobMd");
    }

    public Blob apply(AzureBlob from) {
        if (from == null) {
            return null;
        }
        Blob blob = this.blobFactory.create(this.blobPr2BlobMd.apply(from.getProperties()));
        blob.setPayload((Payload)Preconditions.checkNotNull((Object)from.getPayload(), (Object)("payload: " + String.valueOf(from))));
        blob.setAllHeaders(from.getAllHeaders());
        return blob;
    }
}

