/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azureblob.binders;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import jakarta.inject.Singleton;
import java.util.Map;
import org.jclouds.http.HttpRequest;
import org.jclouds.io.ContentMetadata;
import org.jclouds.rest.Binder;

@Singleton
public class BindAzureContentMetadataToRequest
implements Binder {
    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        String contentType;
        String contentLanguage;
        String contentEncoding;
        String contentDisposition;
        Preconditions.checkArgument((boolean)(Preconditions.checkNotNull((Object)input, (Object)"input") instanceof ContentMetadata), (Object)"this binder is only valid for ContentMetadata");
        Preconditions.checkNotNull(request, (Object)"request");
        ContentMetadata contentMetadata = (ContentMetadata)input;
        ImmutableMap.Builder headers = ImmutableMap.builder();
        String cacheControl = contentMetadata.getCacheControl();
        if (cacheControl != null) {
            headers.put((Object)"x-ms-blob-cache-control", (Object)cacheControl);
        }
        if ((contentDisposition = contentMetadata.getContentDisposition()) != null) {
            headers.put((Object)"x-ms-blob-content-disposition", (Object)contentDisposition);
        }
        if ((contentEncoding = contentMetadata.getContentEncoding()) != null) {
            headers.put((Object)"x-ms-blob-content-encoding", (Object)contentEncoding);
        }
        if ((contentLanguage = contentMetadata.getContentLanguage()) != null) {
            headers.put((Object)"x-ms-blob-content-language", (Object)contentLanguage);
        }
        if ((contentType = contentMetadata.getContentType()) != null) {
            headers.put((Object)"x-ms-blob-content-type", (Object)contentType);
        }
        return (R)((HttpRequest.Builder)request.toBuilder().replaceHeaders((Multimap)Multimaps.forMap((Map)headers.build()))).build();
    }
}

