/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azure.storage.util;

import jakarta.inject.Inject;
import java.io.InputStream;
import javax.inject.Provider;
import org.jclouds.azure.storage.domain.AzureStorageError;
import org.jclouds.azure.storage.filters.SharedKeyLiteAuthentication;
import org.jclouds.azure.storage.xml.ErrorHandler;
import org.jclouds.http.HttpCommand;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.functions.ParseSax;

public class AzureStorageUtils {
    @Inject
    SharedKeyLiteAuthentication signer;
    @Inject
    ParseSax.Factory factory;
    @Inject
    Provider<ErrorHandler> errorHandlerProvider;

    public AzureStorageError parseAzureStorageErrorFromContent(HttpCommand command, HttpResponse response, InputStream content) throws HttpException {
        AzureStorageError error = (AzureStorageError)this.factory.create((ParseSax.HandlerWithResult)this.errorHandlerProvider.get()).parse(content);
        error.setRequestId(response.getFirstHeaderOrNull("x-ms-request-id"));
        if ("AuthenticationFailed".equals(error.getCode())) {
            error.setStringSigned(this.signer.createStringToSign(command.getCurrentRequest()));
            error.setSignature(this.signer.signString(error.getStringSigned()));
        }
        return error;
    }
}

