/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azure.storage.config;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.List;
import org.jclouds.http.HttpRequest;
import org.jclouds.oauth.v2.config.OAuthConfigFactory;
import org.jclouds.oauth.v2.config.OAuthScopes;

public class AzureStorageOAuthConfigFactory
implements OAuthConfigFactory {
    private final OAuthScopes scopes;
    @Named(value="jclouds.oauth.audience")
    @Inject(optional=true)
    private String audience;
    @Named(value="jclouds.oauth.resource")
    @Inject(optional=true)
    private String resource;
    @Named(value="jclouds.azureblob.account")
    @Inject
    private String account;

    @Inject
    AzureStorageOAuthConfigFactory(OAuthScopes scopes) {
        this.scopes = scopes;
    }

    public OAuthConfigFactory.OAuthConfig forRequest(HttpRequest input) {
        Object authAudience;
        Object authResource = this.resource;
        if (authResource == null) {
            authResource = "https://" + this.account + ".blob.core.windows.net";
        }
        if ((authAudience = this.audience) == null) {
            authAudience = "https://" + this.account + ".blob.core.windows.net";
        }
        return OAuthConfigFactory.OAuthConfig.create((List)this.scopes.forRequest(input), (String)authAudience, (String)authResource);
    }
}

