/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.options;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;

public class CreateVolumeSnapshotOptions
implements MapBinder {
    public static final CreateVolumeSnapshotOptions NONE = new CreateVolumeSnapshotOptions();
    @Inject
    private BindToJsonPayload jsonBinder;
    private String name;
    private String description;
    private boolean force = false;

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        HashMap data = Maps.newHashMap(postParams);
        if (this.name != null) {
            data.put("display_name", this.name);
        }
        if (this.description != null) {
            data.put("display_description", this.description);
        }
        if (this.force) {
            data.put("force", "true");
        }
        return (R)this.jsonBinder.bindToRequest(request, (Map)ImmutableMap.of((Object)"snapshot", (Object)data));
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object toBind) {
        throw new IllegalStateException("CreateSnapshot is a POST operation");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CreateVolumeSnapshotOptions)) {
            return false;
        }
        CreateVolumeSnapshotOptions other = (CreateVolumeSnapshotOptions)CreateVolumeSnapshotOptions.class.cast(object);
        return Objects.equal((Object)this.name, (Object)other.name) && Objects.equal((Object)this.description, (Object)other.description);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.description});
    }

    protected MoreObjects.ToStringHelper string() {
        return MoreObjects.toStringHelper((String)"").add("name", (Object)this.name).add("description", (Object)this.description);
    }

    public String toString() {
        return this.string().toString();
    }

    public CreateVolumeSnapshotOptions name(String name) {
        this.name = name;
        return this;
    }

    public CreateVolumeSnapshotOptions description(String description) {
        this.description = description;
        return this;
    }

    public CreateVolumeSnapshotOptions force() {
        this.force = true;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isForce() {
        return this.force;
    }

    public static class Builder {
        public static CreateVolumeSnapshotOptions name(String name) {
            return new CreateVolumeSnapshotOptions().name(name);
        }

        public static CreateVolumeSnapshotOptions description(String description) {
            return new CreateVolumeSnapshotOptions().description(description);
        }

        public static CreateVolumeSnapshotOptions force() {
            return new CreateVolumeSnapshotOptions().force();
        }
    }
}

