/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.functions.internal;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.inject.TypeLiteral;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.beans.ConstructorProperties;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.Arg0ToPagedIterable;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.Json;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.domain.Image;
import org.jclouds.openstack.nova.v2_0.features.ImageApi;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.PaginatedCollection;
import org.jclouds.openstack.v2_0.options.PaginationOptions;

@Singleton
@Beta
public class ParseImageDetails
extends ParseJson<Images> {
    @Inject
    public ParseImageDetails(Json json) {
        super(json, TypeLiteral.get(Images.class));
    }

    static class Images
    extends PaginatedCollection<Image> {
        @ConstructorProperties(value={"images", "images_links"})
        protected Images(Iterable<Image> images, Iterable<Link> images_links) {
            super(images, images_links);
        }
    }

    public static class ToPagedIterable
    extends Arg0ToPagedIterable.FromCaller<Image, ToPagedIterable> {
        private final NovaApi api;

        @Inject
        protected ToPagedIterable(NovaApi api) {
            this.api = (NovaApi)Preconditions.checkNotNull((Object)api, (Object)"api");
        }

        protected Function<Object, IterableWithMarker<Image>> markerToNextForArg0(Optional<Object> arg0) {
            String region = arg0.get().toString();
            final ImageApi imageApi = this.api.getImageApi(region);
            return new Function<Object, IterableWithMarker<Image>>(){

                public IterableWithMarker<Image> apply(Object input) {
                    PaginationOptions paginationOptions = (PaginationOptions)PaginationOptions.class.cast(input);
                    return (IterableWithMarker)IterableWithMarker.class.cast(imageApi.listInDetail(paginationOptions));
                }

                public String toString() {
                    return "listInDetail()";
                }
            };
        }
    }
}

