/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.annotations.Beta;
import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.auth.filters.AuthenticateRequest;
import org.jclouds.openstack.nova.v2_0.domain.Quota;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.binders.BindToJsonPayload;

@Extension(of="compute", namespace="http://docs.openstack.org/ext/quotas-sets/api/v1.1", name="Quotas", alias="os-quota-sets")
@RequestFilters(value={AuthenticateRequest.class})
@Consumes(value={"application/json"})
@Path(value="/os-quota-sets")
@Beta
public interface QuotaApi {
    @Named(value="quota:get")
    @GET
    @SelectJson(value={"quota_set"})
    @Path(value="/{id}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Quota getByTenant(@PathParam(value="id") String var1);

    @Named(value="quota:update")
    @PUT
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    @MapBinder(value=BindToJsonPayload.class)
    public boolean updateQuotaOfTenant(@PayloadParam(value="quota_set") Quota var1, @PathParam(value="id") String var2);

    @Named(value="quota:get")
    @GET
    @SelectJson(value={"quota_set"})
    @Path(value="/{id}/defaults")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Quota getDefaultsForTenant(@PathParam(value="id") String var1);
}

