/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.annotations.Beta;
import com.google.common.collect.FluentIterable;
import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.auth.filters.AuthenticateRequest;
import org.jclouds.openstack.nova.v2_0.binders.BindKeyPairToJsonPayload;
import org.jclouds.openstack.nova.v2_0.domain.KeyPair;
import org.jclouds.openstack.nova.v2_0.functions.internal.ParseKeyPairs;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;

@Extension(of="compute", namespace="http://docs.openstack.org/ext/keypairs/api/v1.1", name="Keypairs", alias="os-keypairs")
@RequestFilters(value={AuthenticateRequest.class})
@Consumes(value={"application/json"})
@Path(value="/os-keypairs")
@Beta
public interface KeyPairApi {
    @Named(value="keypair:list")
    @GET
    @ResponseParser(value=ParseKeyPairs.class)
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public FluentIterable<KeyPair> list();

    @Named(value="keypair:create")
    @POST
    @SelectJson(value={"keypair"})
    @Produces(value={"application/json"})
    @Payload(value="%7B\"keypair\":%7B\"name\":\"{name}\"%7D%7D")
    public KeyPair create(@PayloadParam(value="name") String var1);

    @Named(value="keypair:create")
    @POST
    @SelectJson(value={"keypair"})
    @Produces(value={"application/json"})
    @MapBinder(value=BindKeyPairToJsonPayload.class)
    public KeyPair createWithPublicKey(@PayloadParam(value="name") String var1, @PayloadParam(value="public_key") String var2);

    @Named(value="keypair:get")
    @GET
    @Path(value="/{name}")
    @SelectJson(value={"keypair"})
    @Consumes(value={"application/json"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public KeyPair get(@PathParam(value="name") String var1);

    @Named(value="keypair:delete")
    @DELETE
    @Path(value="/{name}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean delete(@PathParam(value="name") String var1);
}

