/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.annotations.Beta;
import com.google.common.collect.FluentIterable;
import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.Map;
import org.jclouds.Fallbacks;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.auth.filters.AuthenticateRequest;
import org.jclouds.openstack.nova.v2_0.domain.HostAggregate;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.WrapWith;

@Extension(of="compute", namespace="http://docs.openstack.org/ext/aggregates/api/v1.1", name="Aggregates", alias="os-aggregates")
@RequestFilters(value={AuthenticateRequest.class})
@Consumes(value={"application/json"})
@Path(value="/os-aggregates")
@Beta
public interface HostAggregateApi {
    @Named(value="hostAggregate:list")
    @GET
    @SelectJson(value={"aggregates"})
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public FluentIterable<HostAggregate> list();

    @Named(value="hostAggregate:get")
    @GET
    @Path(value="/{id}")
    @SelectJson(value={"aggregate"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public HostAggregate get(@PathParam(value="id") String var1);

    @Named(value="hostAggregate:create")
    @POST
    @SelectJson(value={"aggregate"})
    @Produces(value={"application/json"})
    @WrapWith(value="aggregate")
    public HostAggregate createInAvailabilityZone(@PayloadParam(value="name") String var1, @PayloadParam(value="availability_zone") String var2);

    @Named(value="hostAggregate:update")
    @POST
    @Path(value="/{id}")
    @SelectJson(value={"aggregate"})
    @WrapWith(value="aggregate")
    public HostAggregate updateName(@PathParam(value="id") String var1, @PayloadParam(value="name") String var2);

    @Named(value="hostAggregate:update")
    @POST
    @Path(value="/{id}")
    @SelectJson(value={"aggregate"})
    @WrapWith(value="aggregate")
    public HostAggregate updateAvailabilityZone(@PathParam(value="id") String var1, @PayloadParam(value="availability_zone") String var2);

    @Named(value="hostAggregate:delete")
    @DELETE
    @Path(value="/{id}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public Boolean delete(@PathParam(value="id") String var1);

    @Named(value="hostAggregate:addHost")
    @POST
    @Path(value="/{id}/action")
    @SelectJson(value={"aggregate"})
    @Produces(value={"application/json"})
    @WrapWith(value="add_host")
    public HostAggregate addHost(@PathParam(value="id") String var1, @PayloadParam(value="host") String var2);

    @Named(value="hostAggregate:removeHost")
    @POST
    @Path(value="/{id}/action")
    @SelectJson(value={"aggregate"})
    @Produces(value={"application/json"})
    @WrapWith(value="remove_host")
    public HostAggregate removeHost(@PathParam(value="id") String var1, @PayloadParam(value="host") String var2);

    @Named(value="hostAggregate:setMetadata")
    @POST
    @Path(value="/{id}/action")
    @SelectJson(value={"aggregate"})
    @Produces(value={"application/json"})
    @WrapWith(value="set_metadata")
    public HostAggregate setMetadata(@PathParam(value="id") String var1, @PayloadParam(value="metadata") Map<String, String> var2);
}

