/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.config;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.inject.Binder;
import com.google.inject.Provides;
import com.google.inject.multibindings.MapBinder;
import jakarta.inject.Singleton;
import java.net.URI;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Provider;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.openstack.keystone.v2_0.config.KeystoneHttpApiModule;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.handlers.NovaErrorHandler;
import org.jclouds.openstack.v2_0.domain.Extension;
import org.jclouds.openstack.v2_0.functions.PresentWhenExtensionAnnotationMatchesExtensionSet;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.rest.config.HttpApiModule;
import org.jclouds.rest.functions.ImplicitOptionalConverter;

@ConfiguresHttpApi
public class NovaHttpApiModule
extends HttpApiModule<NovaApi> {
    protected void configure() {
        this.bind(ImplicitOptionalConverter.class).to(PresentWhenExtensionAnnotationMatchesExtensionSet.class);
        super.configure();
        this.bindDefaultAliases();
    }

    private void bindDefaultAliases() {
        MapBinder aliases = KeystoneHttpApiModule.namespaceAliasBinder((Binder)this.binder());
        aliases.addBinding((Object)URI.create("http://docs.openstack.org/ext/securitygroups/api/v1.1")).toInstance((Object)URI.create("http://docs.openstack.org/compute/ext/securitygroups/api/v1.1"));
        aliases.addBinding((Object)URI.create("http://docs.openstack.org/ext/floating_ips/api/v1.1")).toInstance((Object)URI.create("http://docs.openstack.org/compute/ext/floating_ips/api/v1.1"));
        aliases.addBinding((Object)URI.create("http://docs.openstack.org/ext/keypairs/api/v1.1")).toInstance((Object)URI.create("http://docs.openstack.org/compute/ext/keypairs/api/v1.1"));
        aliases.addBinding((Object)URI.create("http://docs.openstack.org/ext/os-simple-tenant-usage/api/v1.1")).toInstance((Object)URI.create("http://docs.openstack.org/compute/ext/os-simple-tenant-usage/api/v1.1"));
        aliases.addBinding((Object)URI.create("http://docs.openstack.org/ext/hosts/api/v1.1")).toInstance((Object)URI.create("http://docs.openstack.org/compute/ext/hosts/api/v1.1"));
        aliases.addBinding((Object)URI.create("http://docs.openstack.org/ext/volumes/api/v1.1")).toInstance((Object)URI.create("http://docs.openstack.org/compute/ext/volumes/api/v1.1"));
        aliases.addBinding((Object)URI.create("http://docs.openstack.org/ext/virtual_interfaces/api/v1.1")).toInstance((Object)URI.create("http://docs.openstack.org/compute/ext/virtual_interfaces/api/v1.1"));
        aliases.addBinding((Object)URI.create("http://docs.openstack.org/ext/createserverext/api/v1.1")).toInstance((Object)URI.create("http://docs.openstack.org/compute/ext/createserverext/api/v1.1"));
        aliases.addBinding((Object)URI.create("http://docs.openstack.org/ext/admin-actions/api/v1.1")).toInstance((Object)URI.create("http://docs.openstack.org/compute/ext/admin-actions/api/v1.1"));
        aliases.addBinding((Object)URI.create("http://docs.openstack.org/ext/aggregates/api/v1.1")).toInstance((Object)URI.create("http://docs.openstack.org/compute/ext/aggregates/api/v1.1"));
        aliases.addBinding((Object)URI.create("http://docs.openstack.org/ext/flavor_extra_specs/api/v1.1")).toInstance((Object)URI.create("http://docs.openstack.org/compute/ext/flavor_extra_specs/api/v1.1"));
        aliases.addBinding((Object)URI.create("http://docs.openstack.org/ext/quotas-sets/api/v1.1")).toInstance((Object)URI.create("http://docs.openstack.org/compute/ext/quotas-sets/api/v1.1"));
        aliases.addBinding((Object)URI.create("http://docs.openstack.org/ext/volume_types/api/v1.1")).toInstance((Object)URI.create("http://docs.openstack.org/compute/ext/volume_types/api/v1.1"));
        aliases.addBinding((Object)URI.create("http://docs.openstack.org/compute/ext/availabilityzone/api/v1.1")).toInstance((Object)URI.create("http://docs.openstack.org/compute/ext/availabilityzone/api/v1.1"));
        aliases.addBinding((Object)URI.create("http://docs.openstack.org/compute/ext/os-volume-attachment-update/api/v2")).toInstance((Object)URI.create("http://docs.openstack.org/compute/ext/os-volume-attachment-update/api/v2"));
        aliases.addBinding((Object)URI.create("http://docs.openstack.org/compute/ext/interfaces/api/v1.1")).toInstance((Object)URI.create("http://docs.openstack.org/compute/ext/interfaces/api/v1.1"));
        aliases.addBinding((Object)URI.create("http://docs.openstack.org/compute/ext/hypervisors/api/v1.1")).toInstance((Object)URI.create("http://docs.openstack.org/compute/ext/hypervisors/api/v1.1"));
    }

    @Provides
    @Singleton
    public final LoadingCache<String, Set<? extends Extension>> provideExtensionsByRegion(final Provider<NovaApi> novaApi) {
        return CacheBuilder.newBuilder().expireAfterWrite(23L, TimeUnit.HOURS).build((CacheLoader)new CacheLoader<String, Set<? extends Extension>>(){

            public Set<? extends Extension> load(String key) throws Exception {
                return ((NovaApi)novaApi.get()).getExtensionApi(key).list();
            }
        });
    }

    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(NovaErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(NovaErrorHandler.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(NovaErrorHandler.class);
    }
}

