/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.Atomics;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.jclouds.compute.config.CustomizationResponse;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.SecurityGroup;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.strategy.CreateNodeWithGroupEncodedIntoName;
import org.jclouds.compute.strategy.CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap;
import org.jclouds.compute.strategy.ListNodesStrategy;
import org.jclouds.compute.strategy.impl.CreateNodesWithGroupEncodedIntoNameThenAddToSet;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.nova.v2_0.NovaApi;
import org.jclouds.openstack.nova.v2_0.compute.functions.AllocateAndAddFloatingIpToNode;
import org.jclouds.openstack.nova.v2_0.compute.options.NodeAndNovaTemplateOptions;
import org.jclouds.openstack.nova.v2_0.compute.options.NovaTemplateOptions;
import org.jclouds.openstack.nova.v2_0.domain.KeyPair;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionAndName;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.RegionSecurityGroupNameAndPorts;
import org.jclouds.openstack.nova.v2_0.extensions.KeyPairApi;

@Singleton
public class ApplyNovaTemplateOptionsCreateNodesWithGroupEncodedIntoNameThenAddToSet
extends CreateNodesWithGroupEncodedIntoNameThenAddToSet {
    public static final String JCLOUDS_SG_PREFIX = "jclouds_sg";
    private final AllocateAndAddFloatingIpToNode createAndAddFloatingIpToNode;
    private final LoadingCache<RegionAndName, SecurityGroup> securityGroupCache;
    private final NovaApi novaApi;
    private final SecurityGroupExtension securityGroupExtension;

    @Inject
    protected ApplyNovaTemplateOptionsCreateNodesWithGroupEncodedIntoNameThenAddToSet(CreateNodeWithGroupEncodedIntoName addNodeWithTagStrategy, ListNodesStrategy listNodesStrategy, GroupNamingConvention.Factory namingConvention, CustomizeNodeAndAddToGoodMapOrPutExceptionIntoBadMap.Factory customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor, AllocateAndAddFloatingIpToNode createAndAddFloatingIpToNode, LoadingCache<RegionAndName, SecurityGroup> securityGroupCache, NovaApi novaApi, SecurityGroupExtension securityGroupExtension) {
        super(addNodeWithTagStrategy, listNodesStrategy, namingConvention, userExecutor, customizeNodeAndAddToGoodMapOrPutExceptionIntoBadMapFactory);
        this.securityGroupCache = (LoadingCache)Preconditions.checkNotNull(securityGroupCache, (Object)"securityGroupCache");
        this.createAndAddFloatingIpToNode = (AllocateAndAddFloatingIpToNode)Preconditions.checkNotNull((Object)createAndAddFloatingIpToNode, (Object)"createAndAddFloatingIpToNode");
        this.novaApi = (NovaApi)Preconditions.checkNotNull((Object)novaApi, (Object)"novaApi");
        this.securityGroupExtension = securityGroupExtension;
    }

    public Map<?, ListenableFuture<Void>> execute(String group, int count, Template template, Set<NodeMetadata> goodNodes, Map<NodeMetadata, Exception> badNodes, Multimap<NodeMetadata, CustomizationResponse> customizationResponses) {
        NovaTemplateOptions templateOptions = (NovaTemplateOptions)NovaTemplateOptions.class.cast(template.getOptions());
        String region = template.getLocation().getId();
        if (templateOptions.shouldAutoAssignFloatingIp()) {
            Preconditions.checkArgument((boolean)this.novaApi.getFloatingIPApi(region).isPresent(), (String)"Floating IPs are required by options, but the extension is not available! options: %s", (Object)templateOptions);
        }
        if (templateOptions.shouldGenerateKeyPair() || templateOptions.getKeyPairName() != null) {
            Preconditions.checkArgument((boolean)this.novaApi.getKeyPairApi(region).isPresent(), (String)"Key Pairs are required by options, but the extension is not available! options: %s", (Object)templateOptions);
        }
        List inboundPorts = Ints.asList((int[])templateOptions.getInboundPorts());
        KeyPair keyPair = null;
        if (templateOptions.shouldGenerateKeyPair()) {
            keyPair = this.generateKeyPair(region, this.namingConvention.create().sharedNameForGroup(group));
            if (Strings.isNullOrEmpty((String)templateOptions.getLoginPrivateKey())) {
                templateOptions.overrideLoginPrivateKey(keyPair.getPrivateKey());
            }
        } else if (templateOptions.getKeyPairName() != null) {
            keyPair = (KeyPair)Preconditions.checkNotNull((Object)((KeyPairApi)this.novaApi.getKeyPairApi(region).get()).get(templateOptions.getKeyPairName()), (String)"keypair %s doesn't exist", (Object)templateOptions.getKeyPairName());
        }
        if (keyPair != null) {
            templateOptions.keyPairName(keyPair.getName());
        }
        ImmutableList.Builder tagsBuilder = ImmutableList.builder();
        if (!templateOptions.getGroups().isEmpty()) {
            Iterable securityGroupNames = Iterables.transform((Iterable)this.securityGroupExtension.listSecurityGroups(), (Function)new Function<SecurityGroup, String>(){

                public String apply(@Nullable SecurityGroup input) {
                    return input.getName();
                }
            });
            for (String securityGroupName : templateOptions.getGroups()) {
                Preconditions.checkState((boolean)Iterables.contains((Iterable)securityGroupNames, (Object)securityGroupName), (Object)("Cannot find security group with name " + securityGroupName + ". \nSecurity groups available are: \n" + Iterables.toString((Iterable)securityGroupNames)));
            }
        } else if (!inboundPorts.isEmpty()) {
            String securityGroupName = this.namingConvention.create().sharedNameForGroup(group);
            for (SecurityGroup existingSecurityGroup : this.securityGroupExtension.listSecurityGroupsInLocation(template.getLocation())) {
                this.securityGroupCache.put((Object)new RegionSecurityGroupNameAndPorts(region, existingSecurityGroup.getName(), inboundPorts), (Object)existingSecurityGroup);
            }
            SecurityGroup securityGroup = (SecurityGroup)this.securityGroupCache.getUnchecked((Object)new RegionSecurityGroupNameAndPorts(region, securityGroupName, inboundPorts));
            templateOptions.securityGroups(new String[]{securityGroup.getName()});
            tagsBuilder.add((Object)String.format("%s-%s", JCLOUDS_SG_PREFIX, securityGroup.getId()));
        }
        templateOptions.tags((Iterable)tagsBuilder.build());
        Map responses = super.execute(group, count, template, goodNodes, badNodes, customizationResponses);
        if (templateOptions.shouldGenerateKeyPair() && keyPair != null) {
            this.registerAutoGeneratedKeyPairCleanupCallbacks(responses, region, keyPair.getName());
        }
        return responses;
    }

    private KeyPair generateKeyPair(String region, String prefix) {
        this.logger.debug(">> creating default keypair for node...", new Object[0]);
        KeyPair keyPair = ((KeyPairApi)this.novaApi.getKeyPairApi(region).get()).create(this.namingConvention.createWithoutPrefix().uniqueNameForGroup(prefix));
        this.logger.debug(">> keypair created! %s", new Object[]{keyPair.getName()});
        return keyPair;
    }

    protected ListenableFuture<AtomicReference<NodeMetadata>> createNodeInGroupWithNameAndTemplate(String group, String name, Template template) {
        ListenableFuture future = super.createNodeInGroupWithNameAndTemplate(group, name, template);
        final NovaTemplateOptions templateOptions = (NovaTemplateOptions)NovaTemplateOptions.class.cast(template.getOptions());
        if (templateOptions.shouldAutoAssignFloatingIp()) {
            ListenableFuture nodeAndNovaTemplateOptions = Futures.transform((ListenableFuture)future, (Function)new Function<AtomicReference<NodeMetadata>, AtomicReference<NodeAndNovaTemplateOptions>>(){

                public AtomicReference<NodeAndNovaTemplateOptions> apply(AtomicReference<NodeMetadata> input) {
                    return NodeAndNovaTemplateOptions.newAtomicReference(input, Atomics.newReference((Object)templateOptions));
                }
            }, (Executor)MoreExecutors.directExecutor());
            return Futures.transform((ListenableFuture)nodeAndNovaTemplateOptions, (Function)this.createAndAddFloatingIpToNode, (Executor)this.userExecutor);
        }
        return future;
    }

    private void registerAutoGeneratedKeyPairCleanupCallbacks(Map<?, ListenableFuture<Void>> responses, final String region, final String generatedKeyPairName) {
        ListenableFuture aggregatedResponses = Futures.successfulAsList(responses.values());
        Futures.addCallback((ListenableFuture)aggregatedResponses, (FutureCallback)new FutureCallback<List<Void>>(){

            public void onSuccess(List<Void> result) {
                this.cleanupAutoGeneratedKeyPair(generatedKeyPairName);
            }

            public void onFailure(Throwable t) {
                this.cleanupAutoGeneratedKeyPair(generatedKeyPairName);
            }

            private void cleanupAutoGeneratedKeyPair(String keyPairName) {
                ApplyNovaTemplateOptionsCreateNodesWithGroupEncodedIntoNameThenAddToSet.this.logger.debug(">> cleaning up auto-generated key pairs...", new Object[0]);
                try {
                    ((KeyPairApi)ApplyNovaTemplateOptionsCreateNodesWithGroupEncodedIntoNameThenAddToSet.this.novaApi.getKeyPairApi(region).get()).delete(keyPairName);
                }
                catch (Exception ex) {
                    ApplyNovaTemplateOptionsCreateNodesWithGroupEncodedIntoNameThenAddToSet.this.logger.warn(">> could not delete key pair %s: %s", new Object[]{keyPairName, ex.getMessage()});
                }
            }
        }, (Executor)this.userExecutor);
    }
}

