/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import jakarta.inject.Inject;
import java.util.Map;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.domain.Location;
import org.jclouds.openstack.nova.v2_0.domain.Image;
import org.jclouds.openstack.nova.v2_0.domain.regionscoped.ImageInRegion;

public class ImageInRegionToImage
implements Function<ImageInRegion, Image> {
    private final Map<Image.Status, Image.Status> toPortableImageStatus;
    private final Function<org.jclouds.openstack.nova.v2_0.domain.Image, OperatingSystem> imageToOs;
    private final Supplier<Map<String, Location>> locationIndex;

    @Inject
    public ImageInRegionToImage(Map<Image.Status, Image.Status> toPortableImageStatus, Function<org.jclouds.openstack.nova.v2_0.domain.Image, OperatingSystem> imageToOs, Supplier<Map<String, Location>> locationIndex) {
        this.toPortableImageStatus = (Map)Preconditions.checkNotNull(toPortableImageStatus, (Object)"toPortableImageStatus");
        this.imageToOs = (Function)Preconditions.checkNotNull(imageToOs, (Object)"imageToOs");
        this.locationIndex = (Supplier)Preconditions.checkNotNull(locationIndex, (Object)"locationIndex");
    }

    public Image apply(ImageInRegion imageInRegion) {
        Location location = (Location)((Map)this.locationIndex.get()).get(imageInRegion.getRegion());
        Preconditions.checkState((location != null ? 1 : 0) != 0, (String)"location %s not in locationIndex: %s", (Object)imageInRegion.getRegion(), (Object)this.locationIndex.get());
        org.jclouds.openstack.nova.v2_0.domain.Image image = imageInRegion.getImage();
        return new ImageBuilder().id(imageInRegion.slashEncode()).providerId(image.getId()).name(image.getName()).userMetadata(image.getMetadata()).operatingSystem((OperatingSystem)this.imageToOs.apply((Object)image)).description(image.getName()).location(location).status(this.toPortableImageStatus.get((Object)image.getStatus())).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).toString();
    }
}

