/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.util;

import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.domain.ShellToken;
import org.jclouds.scriptbuilder.functionloader.CurrentFunctionLoader;

public class Utils {
    private static final Pattern pattern = Pattern.compile("\\{([^\\{]+?)\\}");
    public static final Map<OsFamily, String> OS_TO_POSITIONAL_VAR_PATTERN = ImmutableMap.of((Object)((Object)OsFamily.UNIX), (Object)"set {key}=$1\nshift\n", (Object)((Object)OsFamily.WINDOWS), (Object)"set {key}=%1\r\nshift\r\n");
    public static final Map<OsFamily, String> OS_TO_LOCAL_VAR_PATTERN = ImmutableMap.of((Object)((Object)OsFamily.UNIX), (Object)"set {key}=\"{value}\"\n", (Object)((Object)OsFamily.WINDOWS), (Object)"set {key}={value}\r\n");
    public static final Map<OsFamily, String> OS_TO_ZERO_PATH = ImmutableMap.of((Object)((Object)OsFamily.WINDOWS), (Object)"set PATH=c:\\windows\\;C:\\windows\\system32;c:\\windows\\system32\\wbem\r\n", (Object)((Object)OsFamily.UNIX), (Object)"export PATH=/usr/ucb/bin:/bin:/sbin:/usr/bin:/usr/sbin\n");

    public static String replaceTokens(String input, Map<String, String> replacements) {
        Matcher matcher = pattern.matcher(input);
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (matcher.find()) {
            String replacement = replacements.get(matcher.group(1));
            builder.append(input, i, matcher.start());
            if (replacement == null) {
                builder.append(matcher.group(0));
            } else {
                builder.append(replacement);
            }
            i = matcher.end();
        }
        builder.append(input, i, input.length());
        return builder.toString();
    }

    public static String writeVariableExporters(Map<String, String> exports, OsFamily family) {
        exports = Utils.transformKeys(exports, new VariableNameForOsFamily(family));
        return Utils.replaceTokens(Utils.writeVariableExporters(exports), ShellToken.tokenValueMap(family));
    }

    public static String writeVariableExporters(Map<String, String> exports) {
        StringBuilder initializers = new StringBuilder();
        for (Map.Entry<String, String> entry : exports.entrySet()) {
            initializers.append(String.format("{export} %s={vq}%s{vq}{lf}", entry.getKey(), entry.getValue()));
        }
        return initializers.toString();
    }

    public static String writeFunction(String function, String source, OsFamily family) {
        return Utils.replaceTokens(Utils.writeFunction(function, source), ShellToken.tokenValueMap(family));
    }

    public static String writeFunctionFromResource(String function, OsFamily family) {
        String lf;
        String toReturn = CurrentFunctionLoader.get().loadFunction(function, family);
        return toReturn.endsWith(lf = ShellToken.LF.to(family)) ? toReturn : toReturn + lf;
    }

    public static String writeFunction(String function, String source) {
        return String.format("{fncl}%s{fncr}%s{fnce}", function, source.replaceAll("^", "   "));
    }

    public static String writePositionalVars(Iterable<String> positionalVariables, OsFamily family) {
        StringBuilder initializers = new StringBuilder();
        for (String positionalVariable : positionalVariables) {
            initializers.append(Utils.replaceTokens(OS_TO_POSITIONAL_VAR_PATTERN.get((Object)family), (Map<String, String>)ImmutableMap.of((Object)"key", (Object)positionalVariable)));
        }
        return initializers.toString();
    }

    public static String writeUnsetVariables(Iterable<String> variablesToUnset, OsFamily family) {
        variablesToUnset = Iterables.transform(variablesToUnset, (Function)new VariableNameForOsFamily(family));
        switch (family) {
            case UNIX: {
                return String.format("unset %s\n", Joiner.on((char)' ').join(variablesToUnset));
            }
            case WINDOWS: {
                StringBuilder initializers = new StringBuilder();
                for (String variableToUnset : variablesToUnset) {
                    initializers.append(Utils.replaceTokens(OS_TO_LOCAL_VAR_PATTERN.get((Object)family), (Map<String, String>)ImmutableMap.of((Object)"key", (Object)variableToUnset, (Object)"value", (Object)"")));
                }
                return initializers.toString();
            }
        }
        throw new UnsupportedOperationException("unsupported os: " + String.valueOf((Object)family));
    }

    public static String writeZeroPath(OsFamily family) {
        return OS_TO_ZERO_PATH.get((Object)family);
    }

    public static String writeComment(String comment, OsFamily family) {
        return String.format("%s%s%s", ShellToken.REM.to(family), comment, ShellToken.LF.to(family));
    }

    public static <K1, K2, V> Map<K2, V> transformKeys(Map<K1, V> in, Function<K1, K2> fn) {
        Preconditions.checkNotNull(in, (Object)"input map");
        Preconditions.checkNotNull(fn, (Object)"function");
        ImmutableMap.Builder returnVal = ImmutableMap.builder();
        for (Map.Entry<K1, V> entry : in.entrySet()) {
            returnVal.put(fn.apply(entry.getKey()), entry.getValue());
        }
        return returnVal.build();
    }

    public static final class VariableNameForOsFamily
    implements Function<String, String> {
        private final OsFamily family;

        public VariableNameForOsFamily(OsFamily family) {
            this.family = family;
        }

        public String apply(String input) {
            String variableNameKey = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, input) + "Variable";
            if (ShellToken.tokenValueMap(this.family).containsKey(variableNameKey)) {
                return ShellToken.tokenValueMap(this.family).get(variableNameKey);
            }
            return input;
        }
    }
}

