/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.scriptbuilder.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.jclouds.scriptbuilder.domain.OsFamily;

public enum ShellToken {
    FS,
    RM,
    CD,
    TMP,
    UID,
    ROOT,
    CLOSE_FD,
    PS,
    MD,
    ESCVAR,
    VQ,
    FNCL,
    FNCR,
    FNCE,
    BEGIN_SCRIPT,
    END_SCRIPT,
    BEGIN_FUNCTIONS,
    EXIT,
    END_FUNCTIONS,
    EXPORT,
    LF,
    SH,
    SOURCE,
    REM,
    RETURN,
    ARGS,
    VARL,
    VARR,
    LIBRARY_PATH_VARIABLE;

    private static final LoadingCache<OsFamily, Map<String, String>> familyToTokenValueMap;

    public static Map<String, String> tokenValueMap(OsFamily family) {
        return (Map)familyToTokenValueMap.getUnchecked((Object)family);
    }

    public String to(OsFamily family) {
        Preconditions.checkNotNull((Object)((Object)family), (Object)"family");
        switch (this) {
            case FS: {
                switch (family) {
                    case WINDOWS: {
                        return "\\";
                    }
                    case UNIX: {
                        return "/";
                    }
                }
            }
            case FNCL: {
                switch (family) {
                    case WINDOWS: {
                        return ":";
                    }
                    case UNIX: {
                        return "function ";
                    }
                }
            }
            case FNCR: {
                switch (family) {
                    case WINDOWS: {
                        return "\r\n";
                    }
                    case UNIX: {
                        return " {\n";
                    }
                }
            }
            case FNCE: {
                switch (family) {
                    case WINDOWS: {
                        return "   exit /b 0\r\n";
                    }
                    case UNIX: {
                        return "   return $?\n}\n";
                    }
                }
            }
            case ESCVAR: {
                switch (family) {
                    case WINDOWS: {
                        return "%";
                    }
                    case UNIX: {
                        return "\\";
                    }
                }
            }
            case PS: {
                switch (family) {
                    case WINDOWS: {
                        return ";";
                    }
                    case UNIX: {
                        return ":";
                    }
                }
            }
            case CLOSE_FD: {
                switch (family) {
                    case WINDOWS: {
                        return ">NUL";
                    }
                    case UNIX: {
                        return ">&-";
                    }
                }
            }
            case RM: {
                switch (family) {
                    case WINDOWS: {
                        return "del";
                    }
                    case UNIX: {
                        return "rm";
                    }
                }
            }
            case MD: {
                switch (family) {
                    case WINDOWS: {
                        return "md";
                    }
                    case UNIX: {
                        return "mkdir -p";
                    }
                }
            }
            case VQ: {
                switch (family) {
                    case WINDOWS: {
                        return "";
                    }
                    case UNIX: {
                        return "\"";
                    }
                }
            }
            case BEGIN_FUNCTIONS: {
                switch (family) {
                    case WINDOWS: {
                        return "GOTO FUNCTION_END\r\n";
                    }
                    case UNIX: {
                        return "";
                    }
                }
            }
            case END_FUNCTIONS: {
                switch (family) {
                    case WINDOWS: {
                        return ":FUNCTION_END\r\n";
                    }
                    case UNIX: {
                        return "";
                    }
                }
            }
            case BEGIN_SCRIPT: {
                switch (family) {
                    case WINDOWS: {
                        return "@echo off\r\n";
                    }
                    case UNIX: {
                        return "#!/bin/bash\nset +u\nshopt -s xpg_echo\nshopt -s expand_aliases\n";
                    }
                }
            }
            case END_SCRIPT: {
                switch (family) {
                    case WINDOWS: {
                        return "exit /b 0\r\n";
                    }
                    case UNIX: {
                        return "exit $?\n";
                    }
                }
            }
            case EXPORT: {
                switch (family) {
                    case WINDOWS: {
                        return "set";
                    }
                    case UNIX: {
                        return "export";
                    }
                }
            }
            case RETURN: {
                switch (family) {
                    case WINDOWS: {
                        return "exit /b";
                    }
                    case UNIX: {
                        return "return";
                    }
                }
            }
            case EXIT: {
                switch (family) {
                    case WINDOWS: {
                        return "exit /b";
                    }
                    case UNIX: {
                        return "exit";
                    }
                }
            }
            case ROOT: {
                switch (family) {
                    case WINDOWS: {
                        return "c:\\";
                    }
                    case UNIX: {
                        return "/";
                    }
                }
            }
            case TMP: {
                switch (family) {
                    case WINDOWS: {
                        return "%TEMP%";
                    }
                    case UNIX: {
                        return "/tmp";
                    }
                }
            }
            case UID: {
                switch (family) {
                    case WINDOWS: {
                        return "%USERNAME%";
                    }
                    case UNIX: {
                        return "$USER";
                    }
                }
            }
            case LF: {
                switch (family) {
                    case WINDOWS: {
                        return "\r\n";
                    }
                    case UNIX: {
                        return "\n";
                    }
                }
            }
            case SH: {
                switch (family) {
                    case WINDOWS: {
                        return "cmd";
                    }
                    case UNIX: {
                        return "sh";
                    }
                }
            }
            case LIBRARY_PATH_VARIABLE: {
                switch (family) {
                    case WINDOWS: {
                        return "PATH";
                    }
                    case UNIX: {
                        return "LD_LIBRARY_PATH";
                    }
                }
            }
            case SOURCE: {
                switch (family) {
                    case WINDOWS: {
                        return "@call";
                    }
                    case UNIX: {
                        return ".";
                    }
                }
            }
            case CD: {
                switch (family) {
                    case WINDOWS: {
                        return "cd /d";
                    }
                    case UNIX: {
                        return "cd";
                    }
                }
            }
            case REM: {
                switch (family) {
                    case WINDOWS: {
                        return "@rem";
                    }
                    case UNIX: {
                        return "#";
                    }
                }
            }
            case ARGS: {
                switch (family) {
                    case WINDOWS: {
                        return "%*";
                    }
                    case UNIX: {
                        return "$@";
                    }
                }
            }
            case VARL: {
                switch (family) {
                    case WINDOWS: {
                        return "%";
                    }
                    case UNIX: {
                        return "$";
                    }
                }
            }
            case VARR: {
                switch (family) {
                    case WINDOWS: {
                        return "%";
                    }
                    case UNIX: {
                        return "";
                    }
                }
            }
        }
        throw new UnsupportedOperationException("token " + String.valueOf((Object)this) + " not configured");
    }

    static {
        familyToTokenValueMap = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<OsFamily, Map<String, String>>(){

            public Map<String, String> load(OsFamily from) {
                HashMap map = Maps.newHashMap();
                for (ShellToken token : ShellToken.values()) {
                    map.put(CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, token.toString()), token.to(from));
                }
                return map;
            }
        });
    }
}

