/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.gogrid.compute.functions;

import com.google.common.base.Function;
import jakarta.annotation.Resource;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.gogrid.domain.ServerImage;
import org.jclouds.gogrid.domain.ServerImageState;
import org.jclouds.logging.Logger;

@Singleton
public class ServerImageToImage
implements Function<ServerImage, Image> {
    public static final Pattern GOGRID_OS_PATTERN = Pattern.compile("([a-zA-Z]*).*");
    public static final Pattern GOGRID_VERSION_PATTERN = Pattern.compile(".* ([0-9.]+) .*");
    @Resource
    @Named(value="jclouds.compute")
    protected Logger logger = Logger.NULL;
    private final Map<ServerImageState, Image.Status> toPortableImageStatus;
    private final Map<OsFamily, Map<String, String>> osVersionMap;

    @Inject
    ServerImageToImage(Map<ServerImageState, Image.Status> toPortableImageStatus, Map<OsFamily, Map<String, String>> osVersionMap) {
        this.toPortableImageStatus = toPortableImageStatus;
        this.osVersionMap = osVersionMap;
    }

    protected OperatingSystem parseOs(ServerImage from) {
        Matcher matcher;
        boolean is64Bit;
        OsFamily osFamily = null;
        String osName = from.getOs().getName();
        String osArch = from.getArchitecture().getDescription();
        String osVersion = null;
        String osDescription = from.getOs().getDescription();
        boolean bl = is64Bit = from.getOs().getName().indexOf("64") != -1 || from.getDescription().indexOf("64") != -1;
        if (osName.startsWith("Windows")) {
            osFamily = OsFamily.WINDOWS;
        } else {
            matcher = GOGRID_OS_PATTERN.matcher(from.getName());
            if (matcher.find()) {
                try {
                    osFamily = OsFamily.fromValue((String)matcher.group(1).toLowerCase());
                }
                catch (IllegalArgumentException e) {
                    this.logger.debug("<< didn't match os(%s)", new Object[]{from.getName()});
                }
            }
        }
        matcher = GOGRID_VERSION_PATTERN.matcher(osName);
        if (matcher.find()) {
            osVersion = ComputeServiceUtils.parseVersionOrReturnEmptyString((OsFamily)osFamily, (String)matcher.group(1), this.osVersionMap);
        }
        return new OperatingSystem(osFamily, osName, osVersion, osArch, osDescription, is64Bit);
    }

    public Image apply(ServerImage from) {
        ImageBuilder builder = new ImageBuilder();
        builder.ids("" + from.getId());
        builder.name(from.getFriendlyName());
        builder.description(from.getDescription());
        builder.operatingSystem(this.parseOs(from));
        builder.status(this.toPortableImageStatus.get((Object)from.getState()));
        return builder.build();
    }
}

