/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v3.features;

import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.auth.filters.AuthenticateRequest;
import org.jclouds.openstack.keystone.v3.domain.Token;
import org.jclouds.openstack.keystone.v3.domain.User;
import org.jclouds.openstack.v2_0.services.Identity;
import org.jclouds.rest.annotations.Endpoint;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.Headers;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;

@Consumes(value={"application/json"})
@RequestFilters(value={AuthenticateRequest.class})
@Endpoint(value=Identity.class)
@Path(value="/auth")
public interface AuthApi {
    @Named(value="token:get")
    @GET
    @SelectJson(value={"token"})
    @Path(value="/tokens")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    @Headers(keys={"X-Subject-Token"}, values={"{token}"})
    public Token get(@PathParam(value="token") String var1);

    @Named(value="token:getuser")
    @GET
    @SelectJson(value={"user"})
    @Path(value="/tokens")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    @Headers(keys={"X-Subject-Token"}, values={"{token}"})
    public User getUserOfToken(@PathParam(value="token") String var1);

    @Named(value="token:check")
    @HEAD
    @Path(value="/tokens")
    @Headers(keys={"X-Subject-Token"}, values={"{token}"})
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean isValid(@PathParam(value="token") String var1);
}

