/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v3.domain;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;
import org.jclouds.openstack.keystone.v3.domain.AutoValue_Project;
import org.jclouds.openstack.keystone.v3.domain.Link;

@AutoValue
public abstract class Project {
    public abstract boolean isDomain();

    @Nullable
    public abstract String description();

    @Nullable
    public abstract String domainId();

    @Nullable
    public abstract String domainName();

    public abstract boolean enabled();

    @Nullable
    public abstract String id();

    public abstract String name();

    @Nullable
    public abstract String parentId();

    @Nullable
    public abstract List<String> tags();

    @Nullable
    public abstract Link link();

    @SerializedNames(value={"is_domain", "description", "domain_id", "domain_name", "enabled", "id", "name", "parent_id", "tags", "links"})
    public static Project create(boolean isDomain, String description, String domainId, String domainName, boolean enabled, String id, String name, String parentId, List<String> tags, Link link) {
        return Project.builder().isDomain(isDomain).description(description).domainId(domainId).domainName(domainName).enabled(enabled).id(id).name(name).parentId(parentId).tags(tags).link(link).build();
    }

    Project() {
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_Project.Builder().isDomain(false).enabled(true);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder isDomain(boolean var1);

        public abstract Builder description(String var1);

        public abstract Builder domainId(String var1);

        public abstract Builder domainName(String var1);

        public abstract Builder enabled(boolean var1);

        public abstract Builder id(String var1);

        public abstract Builder name(String var1);

        public abstract Builder parentId(String var1);

        public abstract Builder tags(List<String> var1);

        public abstract Builder link(Link var1);

        abstract List<String> tags();

        abstract Project autoBuild();

        public Project build() {
            this.tags((List<String>)(this.tags() == null ? null : ImmutableList.copyOf(this.tags())));
            return this.autoBuild();
        }
    }
}

