/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v3.domain;

import com.google.auto.value.AutoValue;
import java.util.List;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;
import org.jclouds.openstack.keystone.v3.domain.AutoValue_Auth;
import org.jclouds.openstack.keystone.v3.domain.AutoValue_Auth_DomainIdScope;
import org.jclouds.openstack.keystone.v3.domain.AutoValue_Auth_DomainScope;
import org.jclouds.openstack.keystone.v3.domain.AutoValue_Auth_Id;
import org.jclouds.openstack.keystone.v3.domain.AutoValue_Auth_Identity;
import org.jclouds.openstack.keystone.v3.domain.AutoValue_Auth_Identity_AccessKeyAuth;
import org.jclouds.openstack.keystone.v3.domain.AutoValue_Auth_Identity_PasswordAuth;
import org.jclouds.openstack.keystone.v3.domain.AutoValue_Auth_Identity_PasswordAuth_UserAuth;
import org.jclouds.openstack.keystone.v3.domain.AutoValue_Auth_Identity_PasswordAuth_UserAuth_DomainAuth;
import org.jclouds.openstack.keystone.v3.domain.AutoValue_Auth_Name;
import org.jclouds.openstack.keystone.v3.domain.AutoValue_Auth_ProjectIdScope;
import org.jclouds.openstack.keystone.v3.domain.AutoValue_Auth_ProjectIdScope_ProjectId;
import org.jclouds.openstack.keystone.v3.domain.AutoValue_Auth_ProjectScope;
import org.jclouds.openstack.keystone.v3.domain.AutoValue_Auth_ProjectScope_ProjectName;

@AutoValue
public abstract class Auth {
    public abstract Identity identity();

    @Nullable
    public abstract Object scope();

    @SerializedNames(value={"identity", "scope"})
    public static Auth create(Identity identity, Object scope) {
        return new AutoValue_Auth(identity, scope);
    }

    @AutoValue
    public static abstract class Identity {
        public abstract List<String> methods();

        @Nullable
        public abstract Id token();

        @Nullable
        public abstract PasswordAuth password();

        @Nullable
        public abstract AccessKeyAuth secret();

        @SerializedNames(value={"methods", "token", "password", "application_credential"})
        public static Identity create(List<String> methods, Id token, PasswordAuth password, AccessKeyAuth accessKeyAuth) {
            return new AutoValue_Auth_Identity(methods, token, password, accessKeyAuth);
        }

        @AutoValue
        public static abstract class PasswordAuth {
            public abstract UserAuth user();

            @SerializedNames(value={"user"})
            public static PasswordAuth create(UserAuth user) {
                return new AutoValue_Auth_Identity_PasswordAuth(user);
            }

            @AutoValue
            public static abstract class UserAuth {
                public abstract String name();

                public abstract DomainAuth domain();

                public abstract String password();

                @SerializedNames(value={"name", "domain", "password"})
                public static UserAuth create(String name, DomainAuth domain, String password) {
                    return new AutoValue_Auth_Identity_PasswordAuth_UserAuth(name, domain, password);
                }

                @AutoValue
                public static abstract class DomainAuth {
                    @Nullable
                    public abstract String name();

                    @SerializedNames(value={"name"})
                    public static DomainAuth create(String name) {
                        return new AutoValue_Auth_Identity_PasswordAuth_UserAuth_DomainAuth(name);
                    }
                }
            }
        }

        @AutoValue
        public static abstract class AccessKeyAuth {
            public abstract String id();

            public abstract String secret();

            @SerializedNames(value={"id", "secret"})
            public static AccessKeyAuth create(String id, String secret) {
                return new AutoValue_Auth_Identity_AccessKeyAuth(id, secret);
            }
        }
    }

    @AutoValue
    public static abstract class DomainScope {
        public abstract Name domain();

        @SerializedNames(value={"domain"})
        public static DomainScope create(Name name) {
            return new AutoValue_Auth_DomainScope(name);
        }
    }

    @AutoValue
    public static abstract class DomainIdScope {
        public abstract Id domain();

        @SerializedNames(value={"domain"})
        public static DomainIdScope create(Id id) {
            return new AutoValue_Auth_DomainIdScope(id);
        }
    }

    @AutoValue
    public static abstract class ProjectIdScope {
        public abstract ProjectId project();

        @SerializedNames(value={"project"})
        public static ProjectIdScope create(ProjectId project) {
            return new AutoValue_Auth_ProjectIdScope(project);
        }

        @AutoValue
        public static abstract class ProjectId {
            public abstract String id();

            @Nullable
            public abstract Object domain();

            @SerializedNames(value={"id", "domain"})
            public static ProjectId create(String id, Object domain) {
                return new AutoValue_Auth_ProjectIdScope_ProjectId(id, domain);
            }

            public static ProjectId create(String id, Name domain) {
                return new AutoValue_Auth_ProjectIdScope_ProjectId(id, domain);
            }

            public static ProjectId create(String id, Id domain) {
                return new AutoValue_Auth_ProjectIdScope_ProjectId(id, domain);
            }
        }
    }

    @AutoValue
    public static abstract class ProjectScope {
        public abstract ProjectName project();

        @SerializedNames(value={"project"})
        public static ProjectScope create(ProjectName project) {
            return new AutoValue_Auth_ProjectScope(project);
        }

        @AutoValue
        public static abstract class ProjectName {
            public abstract String name();

            @Nullable
            public abstract Object domain();

            @SerializedNames(value={"name", "domain"})
            public static ProjectName create(String name, Object domain) {
                return new AutoValue_Auth_ProjectScope_ProjectName(name, domain);
            }

            public static ProjectName create(String name, Name domain) {
                return new AutoValue_Auth_ProjectScope_ProjectName(name, domain);
            }

            public static ProjectName create(String name, Id domain) {
                return new AutoValue_Auth_ProjectScope_ProjectName(name, domain);
            }
        }
    }

    public static class Scope {
        public static final String PROJECT = "project";
        public static final String PROJECT_ID = "projectId";
        public static final String DOMAIN = "domain";
        public static final String DOMAIN_ID = "domainId";
        public static final String UNSCOPED = "unscoped";
    }

    @AutoValue
    public static abstract class Name {
        @Nullable
        public abstract String name();

        @SerializedNames(value={"name"})
        public static Name create(String name) {
            return new AutoValue_Auth_Name(name);
        }
    }

    @AutoValue
    public static abstract class Id {
        public abstract String id();

        @SerializedNames(value={"id"})
        public static Id create(String id) {
            return new AutoValue_Auth_Id(id);
        }
    }
}

