/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.options;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import java.util.Map;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;

public class UpdateUserOptions
implements MapBinder {
    @Inject
    private BindToJsonPayload jsonBinder;
    private String name;
    private String email;
    private String password;
    private boolean enabled;

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof UpdateUserOptions) {
            UpdateUserOptions other = (UpdateUserOptions)UpdateUserOptions.class.cast(object);
            return Objects.equal((Object)this.name, (Object)other.name) && Objects.equal((Object)this.email, (Object)other.email) && Objects.equal((Object)this.enabled, (Object)other.enabled) && Objects.equal((Object)this.password, (Object)other.password);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.email, this.enabled, this.password});
    }

    protected MoreObjects.ToStringHelper string() {
        MoreObjects.ToStringHelper toString = MoreObjects.toStringHelper((String)"").omitNullValues();
        toString.add("name", (Object)this.name);
        toString.add("email", (Object)this.email);
        toString.add("password", (Object)this.password);
        toString.add("enabled", (Object)this.enabled);
        return toString;
    }

    public String toString() {
        return this.string().toString();
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        ServerRequest user = new ServerRequest();
        if (this.email != null) {
            user.email = this.email;
        }
        if (this.name != null) {
            user.name = this.name;
        }
        if (this.password != null) {
            user.password = this.password;
        }
        user.enabled = this.enabled;
        return this.bindToRequest(request, ImmutableMap.of((Object)"user", (Object)user));
    }

    public String getName() {
        return this.name;
    }

    public UpdateUserOptions name(String name) {
        this.name = name;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public UpdateUserOptions password(String password) {
        this.password = password;
        return this;
    }

    public String getEmail() {
        return this.email;
    }

    public UpdateUserOptions email(String email) {
        this.email = email;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public UpdateUserOptions enabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        return (R)this.jsonBinder.bindToRequest(request, input);
    }

    static class ServerRequest {
        String name;
        String email;
        String password;
        boolean enabled;

        ServerRequest() {
        }
    }

    public static class Builder {
        public static UpdateUserOptions name(String name) {
            UpdateUserOptions options = new UpdateUserOptions();
            return options.name(name);
        }

        public static UpdateUserOptions email(String email) {
            UpdateUserOptions options = new UpdateUserOptions();
            return options.email(email);
        }

        public static UpdateUserOptions enabled(boolean enabled) {
            UpdateUserOptions options = new UpdateUserOptions();
            return options.enabled(enabled);
        }

        public static UpdateUserOptions password(String password) {
            UpdateUserOptions options = new UpdateUserOptions();
            return options.password(password);
        }
    }
}

