/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.domain;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Named;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.v2_0.domain.MediaType;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.Resource;

public class ApiMetadata
extends Resource {
    private final String status;
    private final Date updated;
    @Named(value="media-types")
    private final Set<MediaType> mediaTypes;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromApiMetadata(this);
    }

    @ConstructorProperties(value={"id", "name", "links", "status", "updated", "media-types"})
    protected ApiMetadata(String id, @Nullable String name, Set<Link> links, @Nullable String status, @Nullable Date updated, Set<MediaType> mediaTypes) {
        super(id, name, links);
        this.status = status;
        this.updated = updated;
        this.mediaTypes = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(mediaTypes, (Object)"mediaTypes")));
    }

    @Nullable
    public String getStatus() {
        return this.status;
    }

    @Nullable
    public Date getUpdated() {
        return this.updated;
    }

    public Set<MediaType> getMediaTypes() {
        return this.mediaTypes;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.status, this.updated, this.mediaTypes});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ApiMetadata that = (ApiMetadata)ApiMetadata.class.cast(obj);
        return super.equals(that) && Objects.equal((Object)this.status, (Object)that.status) && Objects.equal((Object)this.updated, (Object)that.updated) && Objects.equal(this.mediaTypes, that.mediaTypes);
    }

    @Override
    protected MoreObjects.ToStringHelper string() {
        return super.string().add("status", (Object)this.status).add("updated", (Object)this.updated).add("mediaTypes", this.mediaTypes);
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Resource.Builder<T> {
        protected String status;
        protected Date updated;
        protected Set<MediaType> mediaTypes = ImmutableSet.of();

        public T status(String status) {
            this.status = status;
            return (T)((Builder)this.self());
        }

        public T updated(Date updated) {
            this.updated = updated;
            return (T)((Builder)this.self());
        }

        public T mediaTypes(Set<MediaType> mediaTypes) {
            this.mediaTypes = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(mediaTypes, (Object)"mediaTypes")));
            return (T)((Builder)this.self());
        }

        public T mediaTypes(MediaType ... in) {
            return this.mediaTypes((Set<MediaType>)ImmutableSet.copyOf((Object[])in));
        }

        @Override
        public ApiMetadata build() {
            return new ApiMetadata(this.id, this.name, this.links, this.status, this.updated, this.mediaTypes);
        }

        public T fromApiMetadata(ApiMetadata in) {
            return ((Builder)((Builder)((Builder)super.fromResource(in)).status(in.getStatus())).updated(in.getUpdated())).mediaTypes(in.getMediaTypes());
        }
    }
}

