/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.options;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.List;
import org.jclouds.googlecomputeengine.options.AutoValue_TargetPoolCreationOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

@AutoValue
public abstract class TargetPoolCreationOptions {
    public abstract String name();

    @Nullable
    public abstract List<URI> healthChecks();

    @Nullable
    public abstract List<URI> instances();

    @Nullable
    public abstract SessionAffinityValue sessionAffinity();

    @Nullable
    public abstract Float failoverRatio();

    @Nullable
    public abstract URI backupPool();

    @Nullable
    public abstract String description();

    @SerializedNames(value={"name", "healthChecks", "instances", "sessionAffinity", "failoverRatio", "backupPool", "description"})
    public static TargetPoolCreationOptions create(String name, List<URI> healthChecks, List<URI> instances, SessionAffinityValue sessionAffinity, Float failoverRatio, URI backupPool, String description) {
        return new AutoValue_TargetPoolCreationOptions(name, healthChecks, instances, sessionAffinity, failoverRatio, backupPool, description);
    }

    TargetPoolCreationOptions() {
    }

    public static enum SessionAffinityValue {
        CLIENT_IP,
        CLIENT_IP_PROTO,
        NONE;

    }

    public static class Builder {
        private String name;
        private List<URI> healthChecks;
        private List<URI> instances;
        private SessionAffinityValue sessionAffinity;
        private Float failoverRatio;
        private URI backupPool;
        private String description;

        public Builder(String name) {
            Preconditions.checkNotNull((Object)name, (Object)"TargetPoolCreationOptions name cannot be null");
            this.name = name;
        }

        public Builder healthChecks(List<URI> healthChecks) {
            this.healthChecks = healthChecks;
            return this;
        }

        public Builder instances(List<URI> instances) {
            this.instances = instances;
            return this;
        }

        public Builder sessionAffinity(SessionAffinityValue sessionAffinity) {
            this.sessionAffinity = sessionAffinity;
            return this;
        }

        public Builder failoverRatio(float failoverRatio) {
            this.failoverRatio = Float.valueOf(failoverRatio);
            return this;
        }

        public Builder backupPool(URI backupPool) {
            this.backupPool = backupPool;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public TargetPoolCreationOptions build() {
            return TargetPoolCreationOptions.create(this.name, this.healthChecks, this.instances, this.sessionAffinity, this.failoverRatio, this.backupPool, this.description);
        }
    }
}

