/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.options;

import com.google.auto.value.AutoValue;
import org.jclouds.googlecomputeengine.options.AutoValue_HttpHealthCheckCreationOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.SerializedNames;

@AutoValue
public abstract class HttpHealthCheckCreationOptions {
    static final String DEFAULT_REQUEST_PATH = "/";
    static final int DEFAULT_PORT = 80;
    static final int DEFAULT_CHECK_INTERVAL_SEC = 5;
    static final int DEFAULT_TIMEOUT_SEC = 5;
    static final int DEFAULT_UNHEALTHY_THRESHOLD = 2;
    static final int DEFAULT_HEALTHY_THRESHOLD = 2;

    @Nullable
    public abstract String host();

    @Nullable
    public abstract String requestPath();

    @Nullable
    public abstract Integer port();

    @Nullable
    public abstract Integer checkIntervalSec();

    @Nullable
    public abstract Integer timeoutSec();

    @Nullable
    public abstract Integer unhealthyThreshold();

    @Nullable
    public abstract Integer healthyThreshold();

    @Nullable
    public abstract String description();

    static HttpHealthCheckCreationOptions createWithDefaults(String host, String requestPath, Integer port, Integer checkIntervalSec, Integer timeoutSec, Integer unhealthyThreshold, Integer healthyThreshold, String description) {
        return HttpHealthCheckCreationOptions.create(host, requestPath != null ? requestPath : DEFAULT_REQUEST_PATH, port != null ? port : 80, checkIntervalSec != null ? checkIntervalSec : 5, timeoutSec != null ? timeoutSec : 5, unhealthyThreshold != null ? unhealthyThreshold : 2, healthyThreshold != null ? healthyThreshold : 2, description);
    }

    @SerializedNames(value={"host", "requestPath", "port", "checkIntervalSec", "timeoutSec", "unhealthyThreshold", "healthyThreshold", "description"})
    static HttpHealthCheckCreationOptions create(String host, String requestPath, Integer port, Integer checkIntervalSec, Integer timeoutSec, Integer unhealthyThreshold, Integer healthyThreshold, String description) {
        return new AutoValue_HttpHealthCheckCreationOptions(host, requestPath, port, checkIntervalSec, timeoutSec, unhealthyThreshold, healthyThreshold, description);
    }

    HttpHealthCheckCreationOptions() {
    }

    public static class Builder {
        private String host;
        private String requestPath;
        private Integer port;
        private Integer checkIntervalSec;
        private Integer timeoutSec;
        private Integer unhealthyThreshold;
        private Integer healthyThreshold;
        private String description;

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder requestPath(String requestPath) {
            this.requestPath = requestPath;
            return this;
        }

        public Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public Builder checkIntervalSec(Integer checkIntervalSec) {
            this.checkIntervalSec = checkIntervalSec;
            return this;
        }

        public Builder timeoutSec(Integer timeoutSec) {
            this.timeoutSec = timeoutSec;
            return this;
        }

        public Builder unhealthyThreshold(Integer unhealthyThreshold) {
            this.unhealthyThreshold = unhealthyThreshold;
            return this;
        }

        public Builder healthyThreshold(Integer healthyThreshold) {
            this.healthyThreshold = healthyThreshold;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public HttpHealthCheckCreationOptions buildWithDefaults() {
            return HttpHealthCheckCreationOptions.createWithDefaults(this.host, this.requestPath, this.port, this.checkIntervalSec, this.timeoutSec, this.unhealthyThreshold, this.healthyThreshold, this.description);
        }

        public HttpHealthCheckCreationOptions buildForPatch() {
            return HttpHealthCheckCreationOptions.create(this.host, this.requestPath, this.port, this.checkIntervalSec, this.timeoutSec, this.unhealthyThreshold, this.healthyThreshold, this.description);
        }
    }
}

