/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.features;

import com.google.common.base.Function;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.googlecloud.domain.ListPage;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.binders.TargetPoolChangeHealthChecksBinder;
import org.jclouds.googlecomputeengine.binders.TargetPoolChangeInstancesBinder;
import org.jclouds.googlecomputeengine.domain.HealthStatus;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.domain.TargetPool;
import org.jclouds.googlecomputeengine.internal.BaseCallerArg0ToIteratorOfListPage;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.googlecomputeengine.options.TargetPoolCreationOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.binders.BindToJsonPayload;

@SkipEncoding(value={47, 61})
@RequestFilters(value={OAuthFilter.class})
@Path(value="/targetPools")
@Consumes(value={"application/json"})
public interface TargetPoolApi {
    @Named(value="TargetPools:get")
    @GET
    @Path(value="/{targetPool}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public TargetPool get(@PathParam(value="targetPool") String var1);

    @Named(value="TargetPools:insert")
    @POST
    @Produces(value={"application/json"})
    public Operation create(@BinderParam(value=BindToJsonPayload.class) TargetPoolCreationOptions var1);

    @Named(value="TargetPools:delete")
    @DELETE
    @Path(value="/{targetPool}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Operation delete(@PathParam(value="targetPool") String var1);

    @Named(value="TargetPools:addInstance")
    @POST
    @Path(value="/{targetPool}/addInstance")
    @MapBinder(value=TargetPoolChangeInstancesBinder.class)
    public Operation addInstance(@PathParam(value="targetPool") String var1, @PayloadParam(value="instances") List<URI> var2);

    @Named(value="TargetPools:removeInstance")
    @POST
    @Path(value="/{targetPool}/removeInstance")
    @MapBinder(value=TargetPoolChangeInstancesBinder.class)
    public Operation removeInstance(@PathParam(value="targetPool") String var1, @PayloadParam(value="instances") List<URI> var2);

    @Named(value="TargetPools:addHealthCheck")
    @POST
    @Path(value="/{targetPool}/addHealthCheck")
    @MapBinder(value=TargetPoolChangeHealthChecksBinder.class)
    public Operation addHealthCheck(@PathParam(value="targetPool") String var1, @PayloadParam(value="healthChecks") List<URI> var2);

    @Named(value="TargetPools:removeHealthCheck")
    @POST
    @Path(value="/{targetPool}/removeHealthCheck")
    @MapBinder(value=TargetPoolChangeHealthChecksBinder.class)
    public Operation removeHealthCheck(@PathParam(value="targetPool") String var1, @PayloadParam(value="healthChecks") List<URI> var2);

    @Named(value="TargetPools:getHealth")
    @POST
    @Path(value="/{targetPool}/getHealth")
    @MapBinder(value=BindToJsonPayload.class)
    public HealthStatus getHealth(@PathParam(value="targetPool") String var1, @PayloadParam(value="instance") URI var2);

    @Named(value="TargetPools:setBackup")
    @POST
    @Path(value="/{targetPool}/setBackup")
    @MapBinder(value=BindToJsonPayload.class)
    @Nullable
    public Operation setBackup(@PathParam(value="targetPool") String var1, @PayloadParam(value="target") URI var2);

    @Named(value="TargetPools:setBackup")
    @POST
    @Path(value="/{targetPool}/setBackup")
    @MapBinder(value=BindToJsonPayload.class)
    @Nullable
    public Operation setBackup(@PathParam(value="targetPool") String var1, @QueryParam(value="failoverRatio") Float var2, @PayloadParam(value="target") URI var3);

    @Named(value="TargetPools:list")
    @GET
    public ListPage<TargetPool> listPage(@Nullable @QueryParam(value="pageToken") String var1, ListOptions var2);

    @Named(value="TargetPools:list")
    @GET
    @Transform(value=TargetPoolPages.class)
    public Iterator<ListPage<TargetPool>> list();

    @Named(value="TargetPools:list")
    @GET
    @Transform(value=TargetPoolPages.class)
    public Iterator<ListPage<TargetPool>> list(ListOptions var1);

    public static final class TargetPoolPages
    extends BaseCallerArg0ToIteratorOfListPage<TargetPool, TargetPoolPages> {
        private final GoogleComputeEngineApi api;

        @Inject
        TargetPoolPages(GoogleComputeEngineApi api) {
            this.api = api;
        }

        protected Function<String, ListPage<TargetPool>> fetchNextPage(final String regionName, final ListOptions options) {
            return new Function<String, ListPage<TargetPool>>(){

                public ListPage<TargetPool> apply(String pageToken) {
                    return api.targetPoolsInRegion(regionName).listPage(pageToken, options);
                }
            };
        }
    }
}

