/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.features;

import com.google.common.base.Function;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import java.util.Iterator;
import org.jclouds.Fallbacks;
import org.jclouds.googlecloud.domain.ListPage;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.domain.MachineType;
import org.jclouds.googlecomputeengine.internal.BaseCallerArg0ToIteratorOfListPage;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.Transform;

@SkipEncoding(value={47, 61})
@RequestFilters(value={OAuthFilter.class})
@Path(value="/machineTypes")
@Consumes(value={"application/json"})
public interface MachineTypeApi {
    @Named(value="MachineTypes:get")
    @GET
    @Path(value="/{machineType}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public MachineType get(@PathParam(value="machineType") String var1);

    @Named(value="MachineTypes:list")
    @GET
    public ListPage<MachineType> listPage(@Nullable @QueryParam(value="pageToken") String var1, ListOptions var2);

    @Named(value="MachineTypes:list")
    @GET
    @Transform(value=MachineTypePages.class)
    public Iterator<ListPage<MachineType>> list();

    @Named(value="MachineTypes:list")
    @GET
    @Transform(value=MachineTypePages.class)
    public Iterator<ListPage<MachineType>> list(ListOptions var1);

    public static final class MachineTypePages
    extends BaseCallerArg0ToIteratorOfListPage<MachineType, MachineTypePages> {
        private final GoogleComputeEngineApi api;

        @Inject
        MachineTypePages(GoogleComputeEngineApi api) {
            this.api = api;
        }

        protected Function<String, ListPage<MachineType>> fetchNextPage(final String zoneName, final ListOptions options) {
            return new Function<String, ListPage<MachineType>>(){

                public ListPage<MachineType> apply(String pageToken) {
                    return api.machineTypesInZone(zoneName).listPage(pageToken, options);
                }
            };
        }
    }
}

