/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.features;

import com.google.common.base.Function;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.net.URI;
import java.util.Iterator;
import org.jclouds.Fallbacks;
import org.jclouds.googlecloud.domain.ListPage;
import org.jclouds.googlecomputeengine.GoogleComputeEngineApi;
import org.jclouds.googlecomputeengine.binders.FirewallBinder;
import org.jclouds.googlecomputeengine.domain.Firewall;
import org.jclouds.googlecomputeengine.domain.Operation;
import org.jclouds.googlecomputeengine.internal.BaseToIteratorOfListPage;
import org.jclouds.googlecomputeengine.options.FirewallOptions;
import org.jclouds.googlecomputeengine.options.ListOptions;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PATCH;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SkipEncoding;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.binders.BindToJsonPayload;

@SkipEncoding(value={47, 61})
@RequestFilters(value={OAuthFilter.class})
@Path(value="/firewalls")
@Consumes(value={"application/json"})
public interface FirewallApi {
    @Named(value="Firewalls:get")
    @GET
    @Path(value="/{firewall}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Firewall get(@PathParam(value="firewall") String var1);

    @Named(value="Firewalls:insert")
    @POST
    @Produces(value={"application/json"})
    @MapBinder(value=FirewallBinder.class)
    public Operation createInNetwork(@PayloadParam(value="name") String var1, @PayloadParam(value="network") URI var2, @PayloadParam(value="options") FirewallOptions var3);

    @Named(value="Firewalls:update")
    @PUT
    @Produces(value={"application/json"})
    @Path(value="/{firewall}")
    public Operation update(@PathParam(value="firewall") String var1, @BinderParam(value=BindToJsonPayload.class) FirewallOptions var2);

    @Named(value="Firewalls:patch")
    @PATCH
    @Produces(value={"application/json"})
    @Path(value="/{firewall}")
    public Operation patch(@PathParam(value="firewall") String var1, @BinderParam(value=BindToJsonPayload.class) FirewallOptions var2);

    @Named(value="Firewalls:delete")
    @DELETE
    @Path(value="/{firewall}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Operation delete(@PathParam(value="firewall") String var1);

    @Named(value="Firewalls:list")
    @GET
    public ListPage<Firewall> listPage(@Nullable @QueryParam(value="pageToken") String var1, ListOptions var2);

    @Named(value="Firewalls:list")
    @GET
    @Transform(value=FirewallPages.class)
    public Iterator<ListPage<Firewall>> list();

    @Named(value="Firewalls:list")
    @GET
    @Transform(value=FirewallPages.class)
    public Iterator<ListPage<Firewall>> list(ListOptions var1);

    public static final class FirewallPages
    extends BaseToIteratorOfListPage<Firewall, FirewallPages> {
        private final GoogleComputeEngineApi api;

        @Inject
        FirewallPages(GoogleComputeEngineApi api) {
            this.api = api;
        }

        protected Function<String, ListPage<Firewall>> fetchNextPage(final ListOptions options) {
            return new Function<String, ListPage<Firewall>>(){

                public ListPage<Firewall> apply(String pageToken) {
                    return api.firewalls().listPage(pageToken, options);
                }
            };
        }
    }
}

