/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.compute.domain.internal;

import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.net.URI;
import java.util.Set;
import javax.inject.Provider;
import org.jclouds.collect.Memoized;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.HardwareBuilder;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.Processor;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.domain.internal.ArbitraryCpuRamTemplateBuilderImpl;
import org.jclouds.compute.options.TemplateOptions;
import org.jclouds.domain.Location;

public class GoogleComputeEngineArbitraryCpuRamTemplateBuilderImpl
extends ArbitraryCpuRamTemplateBuilderImpl {
    @Inject
    protected GoogleComputeEngineArbitraryCpuRamTemplateBuilderImpl(@Memoized Supplier<Set<? extends Location>> locations, @Memoized Supplier<Set<? extends Image>> images, @Memoized Supplier<Set<? extends Hardware>> hardwares, Supplier<Location> defaultLocation, @Named(value="DEFAULT") Provider<TemplateOptions> optionsProvider, @Named(value="DEFAULT") Provider<TemplateBuilder> defaultTemplateProvider) {
        super(locations, images, hardwares, defaultLocation, optionsProvider, defaultTemplateProvider);
    }

    protected Hardware automaticHardware(double cores, int ram, Optional<Float> disk) {
        if (this.location == null) {
            this.location = (Location)this.defaultLocation.get();
        }
        String uri = this.location.getDescription() + "/machineTypes/custom-" + (int)cores + "-" + ram;
        return new HardwareBuilder().id(uri).ram(ram).processor(new Processor((double)((int)cores), 1.0)).providerId(uri).uri(URI.create(uri)).build();
    }
}

