/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.googlecomputeengine.binders;

import jakarta.inject.Inject;
import java.util.Map;
import org.jclouds.googlecomputeengine.options.HttpHealthCheckCreationOptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.json.Json;
import org.jclouds.rest.binders.BindToJsonPayload;

public class HttpHealthCheckCreationBinder
extends BindToJsonPayload {
    @Inject
    HttpHealthCheckCreationBinder(Json jsonBinder) {
        super(jsonBinder);
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        HttpHealthCheckCreationOptions options = (HttpHealthCheckCreationOptions)postParams.get("options");
        String name = postParams.get("name").toString();
        HttpHealthCheckBinderHelper helper = new HttpHealthCheckBinderHelper(name, options);
        return (R)super.bindToRequest(request, (Object)helper);
    }

    private static class HttpHealthCheckBinderHelper {
        private String name;
        private String host;
        private String requestPath;
        private Integer port;
        private Integer checkIntervalSec;
        private Integer timeoutSec;
        private Integer unhealthyThreshold;
        private Integer healthyThreshold;
        private String description;

        private HttpHealthCheckBinderHelper(String name, HttpHealthCheckCreationOptions httpHealthCheckCreationOptions) {
            this.name = name;
            this.host = httpHealthCheckCreationOptions.host();
            this.requestPath = httpHealthCheckCreationOptions.requestPath();
            this.port = httpHealthCheckCreationOptions.port();
            this.checkIntervalSec = httpHealthCheckCreationOptions.checkIntervalSec();
            this.timeoutSec = httpHealthCheckCreationOptions.timeoutSec();
            this.unhealthyThreshold = httpHealthCheckCreationOptions.unhealthyThreshold();
            this.healthyThreshold = httpHealthCheckCreationOptions.healthyThreshold();
            this.description = httpHealthCheckCreationOptions.description();
        }
    }
}

