/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.util;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.TreeMultimap;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import com.google.common.hash.HashingInputStream;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteSource;
import com.google.common.io.ByteStreams;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Map;
import javax.crypto.Mac;
import org.jclouds.crypto.Crypto;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.util.Closeables2;

public final class AWSRequestSignerV4 {
    public static final String AUTH_TAG = "AWS4";
    public static final String HEADER_TAG = "x-amz-";
    public static final String ALGORITHM = "AWS4-HMAC-SHA256";
    public static final String TERMINATION_STRING = "aws4_request";
    public static final String REGION = "us-east-1";
    public static final String SERVICE = "glacier";
    private final Crypto crypto;
    private final String identity;
    private final String credential;

    public AWSRequestSignerV4(String identity, String credential, Crypto crypto) {
        this.crypto = (Crypto)Preconditions.checkNotNull((Object)crypto, (Object)"crypto");
        this.identity = (String)Preconditions.checkNotNull((Object)identity, (Object)"identity");
        this.credential = (String)Preconditions.checkNotNull((Object)credential, (Object)"credential");
    }

    private static HashCode buildHashedCanonicalRequest(String method, String endpoint, HashCode hashedPayload, String canonicalizedHeadersString, String signedHeaders) {
        return Hashing.sha256().newHasher().putString((CharSequence)method, Charsets.UTF_8).putString((CharSequence)"\n", Charsets.UTF_8).putString((CharSequence)endpoint, Charsets.UTF_8).putString((CharSequence)"\n", Charsets.UTF_8).putString((CharSequence)"\n", Charsets.UTF_8).putString((CharSequence)canonicalizedHeadersString, Charsets.UTF_8).putString((CharSequence)"\n", Charsets.UTF_8).putString((CharSequence)signedHeaders, Charsets.UTF_8).putString((CharSequence)"\n", Charsets.UTF_8).putString((CharSequence)hashedPayload.toString(), Charsets.UTF_8).hash();
    }

    private static String createStringToSign(String date, String credentialScope, HashCode hashedCanonicalRequest) {
        return "AWS4-HMAC-SHA256\n" + date + "\n" + credentialScope + "\n" + hashedCanonicalRequest.toString();
    }

    private static String formatDateWithoutTimestamp(String date) {
        return date.substring(0, 8);
    }

    private static String buildCredentialScope(String dateWithoutTimeStamp) {
        return dateWithoutTimeStamp + "/us-east-1/glacier/aws4_request";
    }

    private static Multimap<String, String> buildCanonicalizedHeadersMap(HttpRequest request) {
        Multimap headers = request.getHeaders();
        TreeMultimap canonicalizedHeaders = TreeMultimap.create();
        for (Map.Entry header : headers.entries()) {
            String key;
            if (header.getKey() == null || !(key = ((String)header.getKey()).toString().toLowerCase(Locale.getDefault())).equalsIgnoreCase("Content-Type") && !key.equalsIgnoreCase("Content-MD5") && !key.equalsIgnoreCase("Host") && !key.startsWith(HEADER_TAG)) continue;
            canonicalizedHeaders.put((Object)key, (Object)((String)header.getValue()));
        }
        return canonicalizedHeaders;
    }

    private static String buildCanonicalizedHeadersString(Multimap<String, String> canonicalizedHeadersMap) {
        StringBuilder canonicalizedHeadersBuffer = new StringBuilder();
        for (Map.Entry header : canonicalizedHeadersMap.entries()) {
            String key = (String)header.getKey();
            canonicalizedHeadersBuffer.append(key.toLowerCase()).append(':').append((String)header.getValue()).append('\n');
        }
        return canonicalizedHeadersBuffer.toString();
    }

    private static String buildSignedHeaders(Multimap<String, String> canonicalizedHeadersMap) {
        return Joiner.on((char)';').join(Iterables.transform((Iterable)canonicalizedHeadersMap.keySet(), (Function)new Function<String, String>(){

            public String apply(String input) {
                return input.toLowerCase();
            }
        }));
    }

    private static HashCode buildHashedPayload(HttpRequest request) {
        HashCode hashCode;
        HashingInputStream his = null;
        try {
            his = new HashingInputStream(Hashing.sha256(), request.getPayload() == null ? ByteSource.empty().openStream() : request.getPayload().openStream());
            ByteStreams.copy((InputStream)his, (OutputStream)ByteStreams.nullOutputStream());
            hashCode = his.hash();
        }
        catch (IOException e) {
            try {
                throw new HttpException("Error signing request", (Throwable)e);
            }
            catch (Throwable throwable) {
                Closeables2.closeQuietly(his);
                throw throwable;
            }
        }
        Closeables2.closeQuietly((Closeable)his);
        return hashCode;
    }

    private static String buildAuthHeader(String accessKey, String credentialScope, String signedHeaders, String signature) {
        return "AWS4-HMAC-SHA256 Credential=" + accessKey + "/" + credentialScope + ",SignedHeaders=" + signedHeaders + ",Signature=" + signature;
    }

    private byte[] hmacSha256(byte[] key, String s) {
        try {
            Mac hmacSHA256 = this.crypto.hmacSHA256(key);
            return hmacSHA256.doFinal(s.getBytes());
        }
        catch (Exception e) {
            throw new HttpException("Error signing request", (Throwable)e);
        }
    }

    private String buildSignature(String dateWithoutTimestamp, String stringToSign) {
        byte[] kSecret = (AUTH_TAG + this.credential).getBytes(Charsets.UTF_8);
        byte[] kDate = this.hmacSha256(kSecret, dateWithoutTimestamp);
        byte[] kRegion = this.hmacSha256(kDate, REGION);
        byte[] kService = this.hmacSha256(kRegion, SERVICE);
        byte[] kSigning = this.hmacSha256(kService, TERMINATION_STRING);
        return BaseEncoding.base16().encode(this.hmacSha256(kSigning, stringToSign)).toLowerCase();
    }

    public HttpRequest sign(HttpRequest request) {
        Multimap<String, String> canonicalizedHeadersMap = AWSRequestSignerV4.buildCanonicalizedHeadersMap(request);
        String canonicalizedHeadersString = AWSRequestSignerV4.buildCanonicalizedHeadersString(canonicalizedHeadersMap);
        String signedHeaders = AWSRequestSignerV4.buildSignedHeaders(canonicalizedHeadersMap);
        String date = request.getFirstHeaderOrNull("x-amz-date");
        String dateWithoutTimestamp = AWSRequestSignerV4.formatDateWithoutTimestamp(date);
        String method = request.getMethod();
        String endpoint = request.getEndpoint().getRawPath();
        String credentialScope = AWSRequestSignerV4.buildCredentialScope(dateWithoutTimestamp);
        HashCode hashedPayload = AWSRequestSignerV4.buildHashedPayload(request);
        HashCode hashedCanonicalRequest = AWSRequestSignerV4.buildHashedCanonicalRequest(method, endpoint, hashedPayload, canonicalizedHeadersString, signedHeaders);
        String stringToSign = AWSRequestSignerV4.createStringToSign(date, credentialScope, hashedCanonicalRequest);
        String signature = this.buildSignature(dateWithoutTimestamp, stringToSign);
        String authHeader = AWSRequestSignerV4.buildAuthHeader(this.identity, credentialScope, signedHeaders, signature);
        request = ((HttpRequest.Builder)request.toBuilder().replaceHeader("Authorization", new String[]{authHeader})).build();
        return request;
    }
}

