/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.predicates.validators;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.inject.Singleton;
import org.jclouds.predicates.Validator;

@Singleton
public final class VaultNameValidator
extends Validator<String> {
    private static final int MIN_LENGTH = 1;
    private static final int MAX_LENGTH = 255;
    private static final CharMatcher VAULT_NAME_ACCEPTABLE_RANGE = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.anyOf((CharSequence)"-_."));

    public void validate(String vaultName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)vaultName) && vaultName.length() <= 255 ? 1 : 0) != 0, (String)"Can't be null or empty. Length must be %s to %s symbols.", (int)1, (int)255);
        Preconditions.checkArgument((boolean)VAULT_NAME_ACCEPTABLE_RANGE.matchesAllOf((CharSequence)vaultName), (Object)"Should contain only ASCII letters and numbers, underscores, hyphens, or periods.");
    }
}

