/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.config;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import jakarta.inject.Named;
import java.util.concurrent.TimeUnit;
import org.jclouds.date.DateService;
import org.jclouds.date.TimeStamp;
import org.jclouds.glacier.GlacierClient;
import org.jclouds.glacier.filters.RequestAuthorizeSignature;
import org.jclouds.glacier.handlers.ParseGlacierErrorFromJsonContent;
import org.jclouds.http.HttpErrorHandler;
import org.jclouds.http.annotation.ClientError;
import org.jclouds.http.annotation.Redirection;
import org.jclouds.http.annotation.ServerError;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.rest.config.HttpApiModule;

@ConfiguresHttpApi
public class GlacierHttpApiModule
extends HttpApiModule<GlacierClient> {
    protected void configure() {
        super.configure();
        this.bind(RequestAuthorizeSignature.class).in(Scopes.SINGLETON);
    }

    @Provides
    @TimeStamp
    protected String provideTimeStamp(@TimeStamp Supplier<String> cache) {
        return (String)cache.get();
    }

    @Provides
    @TimeStamp
    Supplier<String> provideTimeStampCache(@Named(value="jclouds.session-interval") long seconds, final DateService dateService) {
        return Suppliers.memoizeWithExpiration((Supplier)new Supplier<String>(){

            public String get() {
                return dateService.iso8601SecondsDateFormat().replaceAll("[-:]", "");
            }
        }, (long)seconds, (TimeUnit)TimeUnit.SECONDS);
    }

    protected void bindErrorHandlers() {
        this.bind(HttpErrorHandler.class).annotatedWith(Redirection.class).to(ParseGlacierErrorFromJsonContent.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ClientError.class).to(ParseGlacierErrorFromJsonContent.class);
        this.bind(HttpErrorHandler.class).annotatedWith(ServerError.class).to(ParseGlacierErrorFromJsonContent.class);
    }
}

