/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.packet.filters;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.util.Collection;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.rest.annotations.ApiVersion;

@Singleton
public class AddApiVersionToRequest
implements HttpRequestFilter {
    private final String apiVersion;

    @Inject
    AddApiVersionToRequest(@ApiVersion String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public HttpRequest filter(HttpRequest request) throws HttpException {
        Collection accept = (Collection)Preconditions.checkNotNull((Object)request.getHeaders().get((Object)"Accept"), (Object)"accept header must not be null");
        String versionHeader = Joiner.on((String)"; ").join((Iterable)ImmutableList.builder().addAll((Iterable)accept).add((Object)String.format("version=%s", this.apiVersion)).build());
        return ((HttpRequest.Builder)request.toBuilder().replaceHeader("Accept", new String[]{versionHeader})).build();
    }
}

