/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.packet.features;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.inject.TypeLiteral;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import java.beans.ConstructorProperties;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.PagedIterable;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.Json;
import org.jclouds.packet.PacketApi;
import org.jclouds.packet.domain.Facility;
import org.jclouds.packet.domain.Href;
import org.jclouds.packet.domain.internal.PaginatedCollection;
import org.jclouds.packet.domain.options.ListOptions;
import org.jclouds.packet.filters.AddApiVersionToRequest;
import org.jclouds.packet.filters.AddXAuthTokenToRequest;
import org.jclouds.packet.functions.BaseToPagedIterable;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.Transform;

@Path(value="/facilities")
@Consumes(value={"application/json"})
@RequestFilters(value={AddXAuthTokenToRequest.class, AddApiVersionToRequest.class})
public interface FacilityApi {
    @Named(value="facility:list")
    @GET
    @ResponseParser(value=ParseFacilities.class)
    @Transform(value=ParseFacilities.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Facility> list();

    @Named(value="facility:list")
    @GET
    @ResponseParser(value=ParseFacilities.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public IterableWithMarker<Facility> list(ListOptions var1);

    public static final class ParseFacilities
    extends ParseJson<Facilities> {
        @Inject
        ParseFacilities(Json json) {
            super(json, TypeLiteral.get(Facilities.class));
        }

        private static class Facilities
        extends PaginatedCollection<Facility> {
            @ConstructorProperties(value={"facilities", "meta"})
            public Facilities(List<Facility> items, PaginatedCollection.Meta meta) {
                super(items, meta);
            }
        }

        private static class ToPagedIterable
        extends BaseToPagedIterable<Facility, ListOptions> {
            @Inject
            ToPagedIterable(PacketApi api, Function<Href, ListOptions> hrefToOptions) {
                super(api, hrefToOptions);
            }

            @Override
            protected IterableWithMarker<Facility> fetchPageUsingOptions(ListOptions options, Optional<Object> arg0) {
                return this.api.facilityApi().list(options);
            }
        }
    }
}

