/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.packet.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import jakarta.inject.Singleton;
import java.util.Arrays;
import java.util.Map;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.packet.domain.OperatingSystem;

@Singleton
public class OperatingSystemToImage
implements Function<OperatingSystem, Image> {
    private static final Map<String, OsFamily> OTHER_OS_MAP = ImmutableMap.builder().put((Object)"nixos", (Object)OsFamily.LINUX).put((Object)"rancher", (Object)OsFamily.LINUX).put((Object)"vmware", (Object)OsFamily.ESX).build();

    public Image apply(OperatingSystem input) {
        ImageBuilder builder = new ImageBuilder();
        builder.ids(input.slug());
        builder.name(input.name());
        builder.description(input.name());
        builder.status(Image.Status.AVAILABLE);
        OsFamily family = (OsFamily)OperatingSystemToImage.findInStandardFamilies(input.distribution()).or(OperatingSystemToImage.findInOtherOSMap(input.distribution())).or((Object)OsFamily.UNRECOGNIZED);
        builder.operatingSystem(org.jclouds.compute.domain.OperatingSystem.builder().name(input.name()).family(family).description(input.name()).version(input.version()).is64Bit(true).build());
        return builder.build();
    }

    private static Optional<OsFamily> findInStandardFamilies(final String label) {
        return Iterables.tryFind(Arrays.asList(OsFamily.values()), (Predicate)new Predicate<OsFamily>(){

            public boolean apply(OsFamily input) {
                return label.contains(input.value());
            }
        });
    }

    private static Optional<OsFamily> findInOtherOSMap(final String label) {
        return Iterables.tryFind(OTHER_OS_MAP.keySet(), (Predicate)new Predicate<String>(){

            public boolean apply(String input) {
                return label.contains(input);
            }
        }).transform((Function)new Function<String, OsFamily>(){

            public OsFamily apply(String input) {
                return OTHER_OS_MAP.get(input);
            }
        });
    }
}

