/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import com.google.common.collect.Sets;
import jakarta.inject.Inject;
import java.util.Set;
import org.jclouds.ec2.domain.Snapshot;
import org.jclouds.ec2.xml.SnapshotHandler;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class DescribeSnapshotsResponseHandler
extends ParseSax.HandlerWithResult<Set<Snapshot>> {
    private Set<Snapshot> snapshots = Sets.newLinkedHashSet();
    private final SnapshotHandler snapshotHandler;
    private int itemDepth = 0;

    @Inject
    public DescribeSnapshotsResponseHandler(SnapshotHandler snapshotHandler) {
        this.snapshotHandler = snapshotHandler;
    }

    public Set<Snapshot> getResult() {
        return this.snapshots;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        ++this.itemDepth;
        this.snapshotHandler.startElement(uri, localName, qName, attributes);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.snapshotHandler.endElement(uri, localName, qName);
        --this.itemDepth;
        if (qName.equals("item") && this.itemDepth == 2) {
            this.snapshots.add(this.snapshotHandler.getResult());
        }
    }

    public void characters(char[] ch, int start, int length) {
        this.snapshotHandler.characters(ch, start, length);
    }

    public DescribeSnapshotsResponseHandler setContext(HttpRequest request) {
        this.snapshotHandler.setContext(request);
        super.setContext(request);
        return this;
    }
}

