/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import com.google.common.base.Supplier;
import com.google.common.collect.Sets;
import jakarta.annotation.Resource;
import jakarta.inject.Inject;
import java.util.Set;
import org.jclouds.ec2.domain.AvailabilityZoneInfo;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.location.Region;
import org.jclouds.logging.Logger;
import org.xml.sax.Attributes;

public class DescribeAvailabilityZonesResponseHandler
extends ParseSax.HandlerWithResult<Set<AvailabilityZoneInfo>> {
    private StringBuilder currentText = new StringBuilder();
    private final Supplier<String> defaultRegion;
    private Set<AvailabilityZoneInfo> availabilityZones = Sets.newLinkedHashSet();
    private String zone;
    @Resource
    protected Logger logger = Logger.NULL;
    private String region;
    private String zoneState;
    private boolean inMessageSet;
    private Set<String> messages = Sets.newHashSet();

    @Inject
    DescribeAvailabilityZonesResponseHandler(@Region Supplier<String> defaultRegion) {
        this.defaultRegion = defaultRegion;
    }

    public void startDocument() {
        this.region = (String)this.defaultRegion.get();
    }

    public Set<AvailabilityZoneInfo> getResult() {
        return this.availabilityZones;
    }

    public void startElement(String uri, String name, String qName, Attributes attrs) {
        if (qName.equals("messageSet")) {
            this.inMessageSet = true;
        }
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("zoneName")) {
            this.zone = this.currentText.toString().trim();
        } else if (qName.equals("regionName")) {
            try {
                this.region = this.currentText.toString().trim();
            }
            catch (IllegalArgumentException e) {
                this.logger.warn((Throwable)e, "unsupported region: %s", new Object[]{this.currentText.toString().trim()});
                this.region = "UNKNOWN";
            }
        } else if (qName.equals("zoneState")) {
            this.zoneState = this.currentText.toString().trim();
        } else if (qName.equals("message")) {
            this.messages.add(this.currentText.toString().trim());
        } else if (qName.equals("messageSet")) {
            this.inMessageSet = false;
        } else if (qName.equals("item") && !this.inMessageSet) {
            this.availabilityZones.add(new AvailabilityZoneInfo(this.zone, this.zoneState, this.region, this.messages));
            this.zone = null;
            this.region = (String)this.defaultRegion.get();
            this.zoneState = null;
            this.messages = Sets.newHashSet();
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

