/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.xml;

import com.google.common.base.Supplier;
import jakarta.annotation.Resource;
import jakarta.inject.Inject;
import java.util.Date;
import org.jclouds.aws.util.AWSUtils;
import org.jclouds.date.DateService;
import org.jclouds.ec2.domain.Attachment;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.location.Region;
import org.jclouds.logging.Logger;
import org.jclouds.rest.internal.GeneratedHttpRequest;

public class AttachmentHandler
extends ParseSax.HandlerForGeneratedRequestWithResult<Attachment> {
    @Resource
    protected Logger logger = Logger.NULL;
    protected final DateService dateService;
    protected final Supplier<String> defaultRegion;
    private StringBuilder currentText = new StringBuilder();
    private String volumeId;
    private String instanceId;
    private String device;
    private Attachment.Status attachmentStatus;
    private Date attachTime;

    @Inject
    AttachmentHandler(DateService dateService, @Region Supplier<String> defaultRegion) {
        this.dateService = dateService;
        this.defaultRegion = defaultRegion;
    }

    public Attachment getResult() {
        String region = AWSUtils.findRegionInArgsOrNull((GeneratedHttpRequest)this.getRequest());
        if (region == null) {
            region = (String)this.defaultRegion.get();
        }
        return new Attachment(region, this.volumeId, this.instanceId, this.device, this.attachmentStatus, this.attachTime);
    }

    public void endElement(String uri, String name, String qName) {
        if (qName.equals("volumeId")) {
            this.volumeId = this.currentText.toString().trim();
        } else if (qName.equals("volumeId")) {
            this.volumeId = this.currentText.toString().trim();
        } else if (qName.equals("status")) {
            this.attachmentStatus = Attachment.Status.fromValue(this.currentText.toString().trim());
        } else if (qName.equals("instanceId")) {
            this.instanceId = this.currentText.toString().trim();
        } else if (qName.equals("device")) {
            this.device = this.currentText.toString().trim();
        } else if (qName.equals("attachTime")) {
            this.attachTime = this.dateService.iso8601DateOrSecondsDateParse(this.currentText.toString().trim());
        }
        this.currentText.setLength(0);
    }

    public void characters(char[] ch, int start, int length) {
        this.currentText.append(ch, start, length);
    }
}

