/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.functions;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.io.BaseEncoding;
import jakarta.inject.Singleton;
import org.jclouds.util.Predicates2;

@Singleton
public class EncodedRSAPublicKeyToBase64
implements Function<Object, String> {
    private static final Predicate<String> ALLOWED_MARKERS = Predicates.or((Predicate[])new Predicate[]{Predicates2.startsWith((String)"ssh-rsa"), Predicates2.startsWith((String)"-----BEGIN CERTIFICATE-----"), Predicates2.startsWith((String)"---- BEGIN SSH2 PUBLIC KEY ----")});

    public String apply(Object from) {
        String fromString = Preconditions.checkNotNull((Object)from, (Object)"input").toString();
        Preconditions.checkArgument((boolean)ALLOWED_MARKERS.apply((Object)fromString), (String)"must be a ssh public key, conforming to %s ", ALLOWED_MARKERS);
        return BaseEncoding.base64().encode(fromString.getBytes(Charsets.UTF_8));
    }
}

