/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.features;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.Multimap;
import jakarta.inject.Named;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import java.util.Map;
import org.jclouds.Fallbacks;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.ec2.binders.BindFiltersToIndexedFormParams;
import org.jclouds.ec2.binders.BindResourceIdsToIndexedFormParams;
import org.jclouds.ec2.binders.BindTagKeysToIndexedFormParams;
import org.jclouds.ec2.binders.BindTagsToIndexedFormParams;
import org.jclouds.ec2.domain.Tag;
import org.jclouds.ec2.xml.DescribeTagsResponseHandler;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SinceApiVersion;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;

@SinceApiVersion(value="2010-08-31")
@RequestFilters(value={FormSigner.class})
@VirtualHost
public interface TagApi {
    @Named(value="CreateTags")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"CreateTags"})
    public void applyToResources(@BinderParam(value=BindTagsToIndexedFormParams.class) Iterable<String> var1, @BinderParam(value=BindResourceIdsToIndexedFormParams.class) Iterable<String> var2);

    @Named(value="CreateTags")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"CreateTags"})
    public void applyToResources(@BinderParam(value=BindTagsToIndexedFormParams.class) Map<String, String> var1, @BinderParam(value=BindResourceIdsToIndexedFormParams.class) Iterable<String> var2);

    @Named(value="DescribeTags")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DescribeTags"})
    @XMLResponseParser(value=DescribeTagsResponseHandler.class)
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public FluentIterable<Tag> list();

    @Named(value="DescribeTags")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DescribeTags"})
    @XMLResponseParser(value=DescribeTagsResponseHandler.class)
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public FluentIterable<Tag> filter(@BinderParam(value=BindFiltersToIndexedFormParams.class) Multimap<String, String> var1);

    @Named(value="DeleteTags")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DeleteTags"})
    public void deleteFromResources(@BinderParam(value=BindTagKeysToIndexedFormParams.class) Iterable<String> var1, @BinderParam(value=BindResourceIdsToIndexedFormParams.class) Iterable<String> var2);

    @Named(value="DeleteTags")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DeleteTags"})
    public void conditionallyDeleteFromResources(@BinderParam(value=BindTagsToIndexedFormParams.class) Map<String, String> var1, @BinderParam(value=BindResourceIdsToIndexedFormParams.class) Iterable<String> var2);
}

