/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.features;

import com.google.common.collect.Multimap;
import jakarta.inject.Named;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import java.util.Set;
import org.jclouds.Fallbacks;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.ec2.binders.BindFiltersToIndexedFormParams;
import org.jclouds.ec2.binders.BindUserIdGroupPairToSourceSecurityGroupFormParams;
import org.jclouds.ec2.domain.SecurityGroup;
import org.jclouds.ec2.domain.UserIdGroupPair;
import org.jclouds.ec2.xml.DescribeSecurityGroupsResponseHandler;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.functions.RegionToEndpointOrProviderIfNull;
import org.jclouds.net.domain.IpProtocol;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;

@RequestFilters(value={FormSigner.class})
@VirtualHost
public interface SecurityGroupApi {
    @Named(value="CreateSecurityGroup")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"CreateSecurityGroup"})
    public void createSecurityGroupInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="GroupName") String var2, @FormParam(value="GroupDescription") String var3);

    @Named(value="DeleteSecurityGroup")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DeleteSecurityGroup"})
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void deleteSecurityGroupInRegionById(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="GroupId") String var2);

    @Named(value="DeleteSecurityGroup")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DeleteSecurityGroup"})
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void deleteSecurityGroupInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="GroupName") String var2);

    @Named(value="DescribeSecurityGroups")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DescribeSecurityGroups"})
    @XMLResponseParser(value=DescribeSecurityGroupsResponseHandler.class)
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<SecurityGroup> describeSecurityGroupsInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, String ... var2);

    @Named(value="DescribeSecurityGroups")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DescribeSecurityGroups"})
    @XMLResponseParser(value=DescribeSecurityGroupsResponseHandler.class)
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<SecurityGroup> describeSecurityGroupsInRegionWithFilter(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @BinderParam(value=BindFiltersToIndexedFormParams.class) Multimap<String, String> var2);

    @Named(value="AuthorizeSecurityGroupIngress")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"AuthorizeSecurityGroupIngress"})
    public void authorizeSecurityGroupIngressInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="GroupName") String var2, @BinderParam(value=BindUserIdGroupPairToSourceSecurityGroupFormParams.class) UserIdGroupPair var3);

    @Named(value="AuthorizeSecurityGroupIngress")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"AuthorizeSecurityGroupIngress"})
    public void authorizeSecurityGroupIngressInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="GroupName") String var2, @FormParam(value="IpProtocol") IpProtocol var3, @FormParam(value="FromPort") int var4, @FormParam(value="ToPort") int var5, @FormParam(value="CidrIp") String var6);

    @Named(value="RevokeSecurityGroupIngress")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"RevokeSecurityGroupIngress"})
    public void revokeSecurityGroupIngressInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="GroupName") String var2, @BinderParam(value=BindUserIdGroupPairToSourceSecurityGroupFormParams.class) UserIdGroupPair var3);

    @Named(value="RevokeSecurityGroupIngress")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"RevokeSecurityGroupIngress"})
    public void revokeSecurityGroupIngressInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="GroupName") String var2, @FormParam(value="IpProtocol") IpProtocol var3, @FormParam(value="FromPort") int var4, @FormParam(value="ToPort") int var5, @FormParam(value="CidrIp") String var6);
}

