/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.features;

import com.google.common.collect.Multimap;
import jakarta.inject.Named;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import java.util.Set;
import org.jclouds.Fallbacks;
import org.jclouds.aws.filters.FormSigner;
import org.jclouds.ec2.binders.BindFiltersToIndexedFormParams;
import org.jclouds.ec2.domain.KeyPair;
import org.jclouds.ec2.xml.DescribeKeyPairsResponseHandler;
import org.jclouds.ec2.xml.KeyPairResponseHandler;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.location.functions.RegionToEndpointOrProviderIfNull;
import org.jclouds.rest.annotations.BinderParam;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.FormParams;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.VirtualHost;
import org.jclouds.rest.annotations.XMLResponseParser;

@RequestFilters(value={FormSigner.class})
@VirtualHost
public interface KeyPairApi {
    @Named(value="CreateKeyPair")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"CreateKeyPair"})
    @XMLResponseParser(value=KeyPairResponseHandler.class)
    public KeyPair createKeyPairInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="KeyName") String var2);

    @Named(value="DescribeKeyPairs")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DescribeKeyPairs"})
    @XMLResponseParser(value=DescribeKeyPairsResponseHandler.class)
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<KeyPair> describeKeyPairsInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, String ... var2);

    @Named(value="DescribeKeyPairs")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DescribeKeyPairs"})
    @XMLResponseParser(value=DescribeKeyPairsResponseHandler.class)
    @Fallback(value=Fallbacks.EmptySetOnNotFoundOr404.class)
    public Set<KeyPair> describeKeyPairsInRegionWithFilter(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @BinderParam(value=BindFiltersToIndexedFormParams.class) Multimap<String, String> var2);

    @Named(value="DeleteKeyPair")
    @POST
    @Path(value="/")
    @FormParams(keys={"Action"}, values={"DeleteKeyPair"})
    public void deleteKeyPairInRegion(@EndpointParam(parser=RegionToEndpointOrProviderIfNull.class) @Nullable String var1, @FormParam(value="KeyName") String var2);
}

