/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.domain;

import java.util.Date;
import org.jclouds.ec2.domain.Attachment;

public class BlockDevice {
    private final String volumeId;
    private final Attachment.Status attachmentStatus;
    private final Date attachTime;
    private final boolean deleteOnTermination;

    public BlockDevice(String volumeId, Attachment.Status attachmentStatus, Date attachTime, boolean deleteOnTermination) {
        this.volumeId = volumeId;
        this.attachmentStatus = attachmentStatus;
        this.attachTime = attachTime;
        this.deleteOnTermination = deleteOnTermination;
    }

    public BlockDevice(String volumeId, boolean deleteOnTermination) {
        this(volumeId, null, null, deleteOnTermination);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attachTime == null ? 0 : this.attachTime.hashCode());
        result = 31 * result + (this.attachmentStatus == null ? 0 : this.attachmentStatus.hashCode());
        result = 31 * result + (this.deleteOnTermination ? 1231 : 1237);
        result = 31 * result + (this.volumeId == null ? 0 : this.volumeId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockDevice other = (BlockDevice)obj;
        if (this.attachTime == null ? other.attachTime != null : !this.attachTime.equals(other.attachTime)) {
            return false;
        }
        if (this.attachmentStatus == null ? other.attachmentStatus != null : !this.attachmentStatus.equals((Object)other.attachmentStatus)) {
            return false;
        }
        if (this.deleteOnTermination != other.deleteOnTermination) {
            return false;
        }
        return !(this.volumeId == null ? other.volumeId != null : !this.volumeId.equals(other.volumeId));
    }

    public String getVolumeId() {
        return this.volumeId;
    }

    public Attachment.Status getAttachmentStatus() {
        return this.attachmentStatus;
    }

    public Date getAttachTime() {
        return this.attachTime;
    }

    public boolean isDeleteOnTermination() {
        return this.deleteOnTermination;
    }

    public String toString() {
        return "[volumeId=" + this.volumeId + ", attachmentStatus=" + String.valueOf((Object)this.attachmentStatus) + ", attachTime=" + String.valueOf(this.attachTime) + ", deleteOnTermination=" + this.deleteOnTermination + "]";
    }
}

