/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.compute.strategy;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Map;
import org.jclouds.compute.domain.Image;
import org.jclouds.compute.domain.OsFamily;
import org.jclouds.compute.strategy.impl.ReturnCredentialsBoundToImage;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.javax.annotation.Nullable;

@Singleton
public class EC2PopulateDefaultLoginCredentialsForImageStrategy
extends ReturnCredentialsBoundToImage {
    public EC2PopulateDefaultLoginCredentialsForImageStrategy() {
        this(null, (Map<String, Credentials>)ImmutableMap.of(), (Map<OsFamily, LoginCredentials>)ImmutableMap.of());
    }

    @Inject
    public EC2PopulateDefaultLoginCredentialsForImageStrategy(@Nullable @Named(value="image") LoginCredentials creds, Map<String, Credentials> credentialStore, Map<OsFamily, LoginCredentials> osFamilyToCredentials) {
        super(creds, credentialStore, osFamilyToCredentials);
    }

    public LoginCredentials apply(Object resourceToAuthenticate) {
        if (this.creds != null) {
            return this.creds;
        }
        LoginCredentials.Builder credentials = LoginCredentials.builder().user("root");
        if (resourceToAuthenticate != null) {
            String owner = null;
            String name = null;
            if (resourceToAuthenticate instanceof org.jclouds.ec2.domain.Image) {
                owner = ((org.jclouds.ec2.domain.Image)org.jclouds.ec2.domain.Image.class.cast(resourceToAuthenticate)).getImageOwnerId();
                name = ((org.jclouds.ec2.domain.Image)org.jclouds.ec2.domain.Image.class.cast(resourceToAuthenticate)).getName();
            } else if (resourceToAuthenticate instanceof Image) {
                owner = (String)((Image)Image.class.cast(resourceToAuthenticate)).getUserMetadata().get("owner");
                name = (String)((Image)Image.class.cast(resourceToAuthenticate)).getUserMetadata().get("name");
            }
            Preconditions.checkArgument((owner != null ? 1 : 0) != 0, (Object)"Resource must be an image (for EC2)");
            if (owner.matches("063491364108|099720109477")) {
                credentials.user("ubuntu");
            } else if (owner.equals("137112412989")) {
                credentials.user("ec2-user");
            } else if (owner.equals("679593333241") && name != null && name.startsWith("CentOS")) {
                credentials.user("centos");
            }
        }
        return credentials.build();
    }
}

